/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.util.array;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.serialize.SerializeUtil;
import java.io.Serializable;
import java.util.Arrays;

public class ShortArray
implements Serializable {
    private static final long serialVersionUID;
    private static final short NOT_USE = Short.MAX_VALUE;
    private short[] m_array = null;
    private int m_startLength = 16;
    private int m_length = 16;
    private int m_nowSize = 0;
    private boolean m_sortFlg = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.util.array.ShortArray");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID(clazz.getName());
    }

    public ShortArray() {
    }

    public ShortArray(int length) {
        this.m_startLength = length < 2 || length > 9999 ? 16 : length;
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void clear() {
        this.m_array = null;
        this.m_length = 16;
        this.m_nowSize = 0;
        this.m_sortFlg = false;
    }

    public final void add(Short value) throws InputException {
        if (value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.add((short)value);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void add(short value) {
        short[] info = null;
        short[] tmp = null;
        info = this.m_array;
        int length = this.m_length;
        int nowSize = this.m_nowSize;
        try {
            try {
                info[nowSize] = value;
            }
            catch (NullPointerException nul) {
                info = new short[length];
                Arrays.fill(info, (short)Short.MAX_VALUE);
                info[nowSize] = value;
                this.m_array = info;
            }
            catch (IndexOutOfBoundsException io) {
                tmp = info;
                info = new short[length *= 2];
                Arrays.fill(info, (short)Short.MAX_VALUE);
                System.arraycopy(tmp, 0, info, 0, nowSize);
                info[nowSize] = value;
                this.m_length = length;
                this.m_array = info;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            tmp = null;
            info = null;
            this.m_sortFlg = false;
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        tmp = null;
        info = null;
        this.m_sortFlg = false;
        ++this.m_nowSize;
    }

    public final void set(int no, Short value) throws InputException {
        if (value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.set(no, (short)value);
    }

    public final void set(int no, short value) throws InputException {
        int nowLen = this.m_nowSize;
        if (no < 0 || no >= nowLen) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.m_array[no] = value;
        this.m_sortFlg = false;
    }

    public final short remove(int no) {
        short[] info = null;
        short[] tmp = null;
        short ret = Short.MAX_VALUE;
        int nowSize = this.m_nowSize;
        int length = this.m_length;
        if (no < 0 || no >= nowSize || nowSize == 0) {
            return Short.MAX_VALUE;
        }
        info = this.m_array;
        ret = info[no];
        info[no] = Short.MAX_VALUE;
        if (no == 0) {
            tmp = info;
            System.arraycopy(tmp, 1, info, 0, nowSize - 1);
            info[nowSize - 1] = Short.MAX_VALUE;
        } else if (nowSize - no != 1) {
            tmp = info;
            System.arraycopy(tmp, 0, info, 0, no);
            System.arraycopy(tmp, no + 1, info, no, nowSize - (no + 1));
            info[nowSize - 1] = Short.MAX_VALUE;
        }
        if (--nowSize != 0 && (double)length * 0.375 >= (double)nowSize) {
            int newLength = length / 2;
            tmp = new short[newLength];
            Arrays.fill(tmp, (short)Short.MAX_VALUE);
            System.arraycopy(info, 0, tmp, 0, newLength);
            info = null;
            info = tmp;
            this.m_length = newLength;
        } else if (nowSize == 0) {
            info = null;
        }
        this.m_array = info;
        this.m_nowSize = nowSize;
        this.m_sortFlg = false;
        info = null;
        tmp = null;
        return ret;
    }

    public final short get(int no) {
        if (no < 0 || no >= this.m_nowSize) {
            return Short.MAX_VALUE;
        }
        return this.m_array[no];
    }

    public final void sort() {
        if (this.m_nowSize != 0) {
            Arrays.sort(this.m_array, 0, this.m_nowSize);
            this.m_sortFlg = true;
        }
    }

    public final int indexOf(short key) {
        return this.indexOf(key, 0);
    }

    public final int indexOf(short key, int index) {
        int ret;
        if (this.m_nowSize != 0) {
            if (!this.m_sortFlg) {
                this.sort();
            }
            ret = (ret = Arrays.binarySearch(this.m_array, key)) < 0 || ret >= this.m_nowSize ? -1 : ret;
        } else {
            ret = -1;
        }
        return ret;
    }

    public final short[] getObjects() {
        return this.m_array;
    }

    public final int size() {
        return this.m_nowSize;
    }
}

