/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.util.box;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.serialize.SerializeUtil;
import com.JRcServer.commons.util.box.BaseBox;
import java.util.Arrays;

public class FlagBox
implements BaseBox {
    private static final long serialVersionUID;
    private static final int FLAG_ELEMENT_LENGTH = 64;
    private static final int FLAG_ELEMENT = 63;
    private static final int FLAG_PAUSE = 6;
    private long[] m_flags = null;
    private int m_size = 0;
    private int m_flgOnLength = 0;
    private int m_nextPoint = 0;
    private int m_lastPoint = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.util.box.FlagBox");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID(clazz.getName());
    }

    public FlagBox() {
    }

    public FlagBox(int size) throws InputException {
        this.create(size);
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void create(int size) throws InputException {
        if (size < 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        int no = ((size & 0x3F) != 0 ? 1 : 0) + ((size & 0xFFFFFFC0) >> 6);
        this.m_flags = new long[no];
        Arrays.fill(this.m_flags, 0L);
        this.m_size = no * 64;
        this.m_flgOnLength = 0;
    }

    public final void clear() {
        this.m_flags = null;
        this.m_size = 0;
        this.m_flgOnLength = 0;
        this.m_nextPoint = 0;
        this.m_lastPoint = 0;
    }

    public final int addSpace(int size) {
        int ret;
        long[] tmp = null;
        if (size > 0 && this.m_flags != null) {
            int newSize = size + this.m_size;
            int no = ((newSize & 0x3F) != 0 ? 1 : 0) + ((newSize & 0xFFFFFFC0) >> 6);
            tmp = new long[no];
            Arrays.fill(tmp, 0L);
            System.arraycopy(this.m_flags, 0, tmp, 0, this.m_flags.length);
            this.m_flags = tmp;
            this.m_size = no * 64;
            ret = newSize;
        } else {
            ret = 0;
        }
        return ret;
    }

    public final int removeSpace(int size) {
        int ret;
        long[] tmp = null;
        if (size > 0 && this.m_flags != null) {
            int insSize;
            int lastSize = this.m_lastPoint + 1;
            int remSize = this.m_size - size;
            int no = ((remSize & 0x3F) != 0 ? 1 : 0) + ((remSize & 0xFFFFFFC0) >> 6);
            int no2 = ((lastSize & 0x3F) != 0 ? 1 : 0) + ((lastSize & 0xFFFFFFC0) >> 6);
            int n = insSize = lastSize <= this.m_size ? no2 : no;
            if (this.m_flags.length > insSize) {
                int newSize;
                ret = this.m_size = (newSize = insSize * 64);
                tmp = new long[insSize];
                Arrays.fill(tmp, 0L);
                System.arraycopy(this.m_flags, 0, tmp, 0, tmp.length);
                this.m_flags = tmp;
            } else {
                ret = this.m_size;
            }
        } else {
            ret = this.m_size;
        }
        return ret;
    }

    public final void add(boolean flg, int no) {
        long[] flags = null;
        flags = this.m_flags;
        if (flags == null || no < 0 || no >= this.m_size) {
            return;
        }
        int indNo = (no & 0xFFFFFFC0) >> 6;
        int indOff = no & 0x3F;
        if (flg) {
            if ((flags[indNo] & 1L << indOff) == 0L) {
                ++this.m_flgOnLength;
            }
            int n = indNo;
            flags[n] = flags[n] | 1L << indOff & 0xFFFFFFFFFFFFFFFFL;
            this.m_nextPoint = indNo;
            this.m_lastPoint = this.m_lastPoint < no ? no : this.m_lastPoint;
        } else {
            if ((flags[indNo] & 1L << indOff) != 0L) {
                --this.m_flgOnLength;
            }
            int n = indNo;
            flags[n] = flags[n] & ((1L << indOff ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFFFFFFFFFL);
            this.m_nextPoint = this.m_nextPoint >= indNo ? indNo : this.m_nextPoint;
            this.getLastCode();
        }
    }

    public final boolean get(int no) {
        long[] flags = null;
        flags = this.m_flags;
        if (flags == null || no < 0 || no >= this.m_size) {
            return false;
        }
        return (flags[(no & 0xFFFFFFC0) >> 6] & 1L << (no & 0x3F)) != 0L;
    }

    public final int getSearch() {
        long[] flags = null;
        int ret = -1;
        int size = 0;
        size = this.m_size;
        flags = this.m_flags;
        if (flags == null) {
            return -1;
        }
        int len = 64;
        int max = flags.length;
        int i = this.m_nextPoint;
        ret = -1;
        boolean flg = false;
        while (i < max && !flg) {
            if (flags[i] != -1L) {
                int j = 0;
                while (j < len) {
                    if ((flags[i] & 1L << j) == 0L) {
                        ret = i * 64 + j;
                        if (ret >= size) {
                            ret = -1;
                            break;
                        }
                        flg = true;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ret;
    }

    public final int getMaxSize() {
        return this.m_size;
    }

    public final int getUseSize() {
        return this.m_flgOnLength;
    }

    public final boolean isData(int no) {
        long[] flags = null;
        flags = this.m_flags;
        if (flags == null || no < 0 || no >= this.m_size) {
            return false;
        }
        return (flags[(no & 0xFFFFFFC0) >> 6] & 1L << (no & 0x3F)) != 0L;
    }

    public final boolean isCreate() {
        return this.m_flags != null;
    }

    private final void getLastCode() {
        long[] flags = null;
        int no = this.m_lastPoint;
        flags = this.m_flags;
        if (this.m_flags != null) {
            int indNo;
            int len = indNo = (no & 0xFFFFFFC0) >> 6;
            int lenJ = 64;
            int i = len;
            int pnt = -1;
            while (i >= 0) {
                if (flags[i] != 0L) {
                    int j = 0;
                    while (j < lenJ) {
                        pnt = (flags[i] & 1L << j) != 0L ? j : pnt;
                        ++j;
                    }
                    if (pnt != -1) {
                        this.m_lastPoint = i * 64 + pnt;
                        break;
                    }
                }
                if (pnt == -1) {
                    this.m_lastPoint = 0;
                }
                --i;
            }
        }
    }
}

