/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.util.box;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.serialize.SerializeUtil;
import com.JRcServer.commons.util.box.BaseBox;
import com.JRcServer.commons.util.box.FlagBox;

public class TripleCharBox
implements BaseBox {
    private static final long serialVersionUID;
    private char[] m_array = null;
    private FlagBox m_flags = null;
    private int m_length = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.util.box.TripleCharBox");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID(clazz.getName());
    }

    public TripleCharBox() {
    }

    public TripleCharBox(int size) throws InputException {
        this.create(size);
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void create(int size) throws InputException {
        if (size < 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        this.m_length = size = (((size & 0x3F) != 0 ? 1 : 0) + ((size & 0xFFFFFFC0) >> 6)) * 64;
        this.m_array = new char[size * 3];
        this.m_flags = new FlagBox(size);
    }

    public final void clear() {
        if (this.m_flags != null) {
            this.m_flags.clear();
        }
        this.m_flags = null;
        this.m_array = null;
        this.m_length = 0;
    }

    public final int addSpace(int size) {
        int len;
        char[] tmp = null;
        if (size > 0) {
            len = this.m_flags.addSpace(size);
            tmp = new char[len * 3];
            System.arraycopy(this.m_array, 0, tmp, 0, this.m_array.length);
            this.m_array = tmp;
            tmp = null;
            this.m_length = len;
        } else {
            len = this.m_length;
        }
        return len;
    }

    public final int removeSpace(int size) {
        int len;
        char[] tmp = null;
        if (size > 0) {
            len = this.m_flags.removeSpace(size);
            if (len != this.m_length) {
                tmp = new char[len * 3];
                System.arraycopy(this.m_array, 0, tmp, 0, tmp.length);
                this.m_array = tmp;
                tmp = null;
                this.m_length = len;
            }
        } else {
            len = this.m_length;
        }
        return len;
    }

    public final int add(char one, char two, char three) {
        int pnt;
        char[] arrays = null;
        FlagBox flgs = null;
        arrays = this.m_array;
        flgs = this.m_flags;
        int ret = -1;
        if (arrays != null && (pnt = flgs.getSearch()) != -1) {
            this.m_flags.add(true, pnt);
            ret = pnt;
            this.m_array[pnt *= 3] = one;
            this.m_array[pnt + 1] = two;
            this.m_array[pnt + 2] = three;
        }
        return ret;
    }

    public final void set(int no, char one, char two, char three) {
        char[] arrays = null;
        FlagBox flgs = null;
        arrays = this.m_array;
        flgs = this.m_flags;
        if (arrays == null || no < 0 || no >= this.m_length) {
            return;
        }
        int pnt = no * 3;
        arrays[pnt] = one;
        arrays[pnt + 1] = two;
        arrays[pnt + 2] = three;
        flgs.add(true, no);
    }

    public final void remove(int no) {
        char[] arrays = null;
        FlagBox flgs = null;
        arrays = this.m_array;
        flgs = this.m_flags;
        if (arrays == null || no < 0 || no >= this.m_length || !flgs.get(no)) {
            return;
        }
        flgs.add(false, no);
    }

    public final char getOne(int no) {
        return this.m_array == null || no < 0 || no >= this.m_length || !this.m_flags.get(no) ? (char)'\u0000' : this.m_array[no * 3];
    }

    public final char getTwo(int no) {
        return this.m_array == null || no < 0 || no >= this.m_length || !this.m_flags.get(no) ? (char)'\u0000' : this.m_array[no * 3 + 1];
    }

    public final char getThree(int no) {
        return this.m_array == null || no < 0 || no >= this.m_length || !this.m_flags.get(no) ? (char)'\u0000' : this.m_array[no * 3 + 2];
    }

    public final int getMaxSize() {
        return this.m_array == null ? 0 : this.m_length;
    }

    public final int getUseSize() {
        return this.m_array == null ? -1 : this.m_flags.getUseSize();
    }

    public final boolean isData(int no) {
        return this.m_array != null && this.m_flags.get(no);
    }

    public final boolean isCreate() {
        return this.m_array != null;
    }
}

