/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.sync;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.sync.ClientChild;
import org.maachang.sync.MaachangSyncProtocol;
import org.maachang.util.ByteUtil;
import org.maachang.util.ConvertBinary;
import org.maachang.util.Encryption;
import org.maachang.util.FileUtil;
import org.maachang.util.net.CreateSocket;
import org.maachang.util.net.ReceiveTimeoutException;
import org.maachang.util.net.Tcp;

public class ClientAction {
    private static final Log LOG;
    private static final long CLIENT_TIMEOUT = 60L;
    private static final int RECEIVE_ERROR_COUNT = 5000;
    private Tcp tcp = null;
    private byte[] keycode = null;
    private String localDir = null;
    private String remoteDir = null;
    private byte[] buffer = new byte[65535];
    private ByteUtil byteUtil = new ByteUtil();
    private Encryption enc = new Encryption();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.maachang.sync.ClientAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    private ClientAction() {
    }

    public ClientAction(Socket socket, String localDir, String remoteDir, String key) throws Exception {
        if (socket == null || localDir == null || localDir.length() <= 0 || remoteDir == null || remoteDir.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (key == null || key.length() <= 0) {
            key = "default-key";
        }
        if (FileUtil.isFileExists(localDir)) {
            throw new Exception("\u6307\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d(" + localDir + ")\u306f\u3001\u30d5\u30a1\u30a4\u30eb\u540d\u3067\u5b58\u5728\u3057\u307e\u3059");
        }
        if (!FileUtil.isDirExists(localDir)) {
            FileUtil.mkdirs(localDir);
        }
        this.tcp = CreateSocket.createTcp(socket);
        this.localDir = FileUtil.getFullPath(localDir);
        this.remoteDir = remoteDir;
        this.keycode = Encryption.convertStringByCode32Key(key);
    }

    protected void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clear() {
        if (this.tcp != null) {
            this.tcp.destroy();
        }
        this.tcp = null;
        this.localDir = null;
        this.remoteDir = null;
        this.keycode = null;
        this.byteUtil = null;
    }

    public void execution(boolean opt) throws Exception {
        this.enc.create(this.keycode);
        int len = ClientAction.getLastByDirectory(opt, this.buffer, this.localDir, this.remoteDir, this.enc);
        this.tcp.send(this.buffer, 0, len);
        this.tcp.flush();
        String ipPort = ClientAction.getIpPort(this.tcp);
        ClientAction.rollback(this.localDir);
        int[] result = new int[1];
        int cnt = 0;
        boolean exitFlg = false;
        ClientChild clientChild = new ClientChild();
        try {
            try {
                int i = 0;
                while (true) {
                    result[0] = 0;
                    len = ClientAction.getReceive(result, this.tcp, this.buffer, this.byteUtil);
                    if (len <= -1) {
                        if (cnt >= 5000) {
                            throw new Exception("\u53d7\u4fe1\u5f85\u3061\u30ab\u30a6\u30f3\u30c8\u306e\u5236\u9650\u5024\u3092\u8d8a\u3057\u307e\u3057\u305f");
                        }
                        ++cnt;
                        continue;
                    }
                    cnt = 0;
                    switch (result[0]) {
                        case 1: {
                            clientChild.clear();
                            this.enc.create(this.keycode);
                            ClientAction.getClientChild(ipPort, clientChild, this.localDir, this.buffer, len, this.enc);
                            break;
                        }
                        case 2: {
                            this.enc.create(this.keycode);
                            i = ClientAction.getOutputFile(clientChild, this.buffer, len, this.enc, i);
                            break;
                        }
                        case 3: {
                            clientChild.clear();
                            ClientAction.commit(this.localDir);
                            exitFlg = true;
                        }
                    }
                    if (exitFlg) break;
                }
            }
            catch (Exception e) {
                ClientAction.rollback(this.localDir);
                throw e;
            }
        }
        finally {
            this.clear();
            LOG.info((Object)("## [" + ipPort + "]\u51e6\u7406\u7d42\u4e86....."));
        }
    }

    private static int getLastByDirectory(boolean opt, byte[] buf, String localDir, String remoteDir, Encryption enc) throws Exception {
        if (!FileUtil.isDirExists(localDir)) {
            throw new Exception("\u6307\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d(" + localDir + ")\u306f\u5b58\u5728\u3057\u306a\u3044\u304b\u4e0d\u6b63\u3067\u3059");
        }
        long lastUpdate = -1L;
        if (!opt) {
            lastUpdate = FileUtil.getDirectoryToLastTime(localDir);
        }
        byte[] fnm = remoteDir.getBytes("UTF8");
        buf[0] = MaachangSyncProtocol.HD_LAST_UPATE[0];
        buf[1] = MaachangSyncProtocol.HD_LAST_UPATE[1];
        int pnt = 2;
        byte[] key = Encryption.getPublicKey();
        System.arraycopy(key, 0, buf, 2, 32);
        int next = pnt += 37;
        ConvertBinary.convertLong(buf, pnt, lastUpdate);
        ConvertBinary.convertInt(buf, pnt += 8, fnm.length);
        System.arraycopy(fnm, 0, buf, pnt += 4, fnm.length);
        int code = enc.encryption(key, buf, next, (pnt += fnm.length) - next);
        buf[34] = (byte)(code & 0xFF);
        ConvertBinary.convertInt(buf, 35, pnt);
        return pnt;
    }

    private static final int getReceive(int[] out, Tcp tcp, byte[] buf, ByteUtil byteUtil) throws Exception {
        int len = -1;
        try {
            len = tcp.receive(buf, -1, 60L);
            byteUtil.add(buf, 0, len);
        }
        catch (ReceiveTimeoutException rt) {
            len = -1;
        }
        int dataLen = byteUtil.size();
        if (dataLen <= 39) {
            return -1;
        }
        Arrays.fill(buf, (byte)0);
        byteUtil.get(buf);
        out[0] = 0;
        int ret = -1;
        if ((buf[0] & 0xFF) == (MaachangSyncProtocol.HD_SYNC_START_FILE[0] & 0xFF) && (buf[1] & 0xFF) == (MaachangSyncProtocol.HD_SYNC_START_FILE[1] & 0xFF)) {
            out[0] = 1;
            ret = MaachangSyncProtocol.getProtocolLength(buf);
            if (ret > dataLen) {
                return -1;
            }
        } else if ((buf[0] & 0xFF) == (MaachangSyncProtocol.HD_SYNC_FILE[0] & 0xFF) && (buf[1] & 0xFF) == (MaachangSyncProtocol.HD_SYNC_FILE[1] & 0xFF)) {
            out[0] = 2;
            ret = MaachangSyncProtocol.getProtocolLength(buf);
            if (ret > dataLen) {
                return -1;
            }
        } else if ((buf[0] & 0xFF) == (MaachangSyncProtocol.HD_END[0] & 0xFF) && (buf[1] & 0xFF) == (MaachangSyncProtocol.HD_END[1] & 0xFF)) {
            out[0] = 3;
            ret = MaachangSyncProtocol.getProtocolLength(buf);
            if (ret > dataLen) {
                return -1;
            }
        } else {
            if (buf[0] == 0 && buf[1] == 0) {
                return -1;
            }
            throw new Exception("\u4e0d\u6b63\u306a\u53d7\u4fe1\u60c5\u5831\u3067\u3059[" + buf[0] + ":" + buf[1] + "]");
        }
        byteUtil.remove(ret);
        return ret;
    }

    private static final void getClientChild(String ipPort, ClientChild clientChild, String localDir, byte[] buf, int length, Encryption enc) throws Exception {
        byte[] key = MaachangSyncProtocol.getKey(buf);
        int code = MaachangSyncProtocol.getCode(buf);
        enc.analysis(key, code, buf, 39, length - 39);
        int pnt = 39;
        int no = ConvertBinary.convertInt(pnt, buf);
        long all = ConvertBinary.convertLong(pnt += 4, buf);
        int pathLen = ConvertBinary.convertInt(pnt += 8, buf);
        pnt += 4;
        if (pathLen <= 0 || pathLen + 55 > length) {
            throw new Exception("\u30bf\u30fc\u30b2\u30c3\u30c8\u30d5\u30a1\u30a4\u30eb\u540d\u9577\u304c\u4e0d\u6b63\u3067\u3059[" + pathLen + "]");
        }
        byte[] nameBin = new byte[pathLen];
        System.arraycopy(buf, pnt, nameBin, 0, pathLen);
        String fileName = new String(nameBin, "UTF8");
        String oneFileName = FileUtil.getFileName(fileName);
        nameBin = null;
        fileName = FileUtil.cutSeparator(true, fileName);
        localDir = FileUtil.cutSeparator(false, localDir);
        String dir = localDir + FileUtil.FILE_SPACE + fileName.substring(0, fileName.length() - oneFileName.length());
        dir = FileUtil.cutSeparator(false, dir);
        dir = String.valueOf(dir) + FileUtil.FILE_SPACE;
        if (!FileUtil.isDirExists(dir)) {
            FileUtil.mkdirs(dir);
        }
        BufferedOutputStream bo = new BufferedOutputStream(new FileOutputStream(String.valueOf(dir) + ".#MAACHANG_SYNC#" + oneFileName));
        clientChild.setTargetName(String.valueOf(dir) + oneFileName);
        clientChild.setTargetFileLength(all);
        clientChild.setFileNo(no);
        clientChild.setTargetFp(bo);
        long kb = clientChild.getTargetFileLength() / 1024L;
        if (kb <= 0L) {
            kb = 1L;
        }
        System.out.println();
        LOG.info((Object)("## [" + ipPort + "]" + clientChild.getTargetName() + "(" + kb + "KByte)"));
    }

    private static final int getOutputFile(ClientChild clientChild, byte[] buf, int length, Encryption enc, int seq) throws Exception {
        byte[] key = MaachangSyncProtocol.getKey(buf);
        int code = MaachangSyncProtocol.getCode(buf);
        enc.analysis(key, code, buf, 39, length - 39);
        int pnt = 39;
        int no = ConvertBinary.convertInt(pnt, buf);
        pnt += 4;
        if (no != clientChild.getFileNo()) {
            throw new Exception("\u30d5\u30a1\u30a4\u30eb\u540d[" + clientChild.getTargetName() + "]\u306e\u9805\u756a[" + clientChild.getFileNo() + "/" + no + "]\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
        }
        int sendLen = ConvertBinary.convertInt(pnt += 4, buf);
        pnt += 4;
        if (sendLen <= 0 || length - 51 != sendLen) {
            throw new Exception("\u30d5\u30a1\u30a4\u30eb\u540d[" + clientChild.getTargetName() + "]\u306e\u53d7\u4fe1\u30b5\u30a4\u30ba[" + sendLen + "]\u304c\u4e0d\u6b63\u3067\u3059");
        }
        OutputStream os = clientChild.getTargetFp();
        os.write(buf, 51, sendLen);
        if (seq >= 5) {
            System.out.print(".");
            seq = 0;
        } else {
            ++seq;
        }
        return seq;
    }

    private static final void commit(String localDir) throws Exception {
        ClientAction.commitToDir(localDir);
    }

    private static final void rollback(String localDir) throws Exception {
        ClientAction.rollbackToDir(localDir);
    }

    private static final void commitToDir(String name) throws Exception {
        int len;
        if (!name.endsWith("\\") && !name.endsWith("/")) {
            name = String.valueOf(name) + FileUtil.FILE_SPACE;
        }
        File file = new File(name);
        String[] names = file.list();
        file = null;
        if (names != null && (len = names.length) > 0) {
            int i = 0;
            while (i < len) {
                String target = String.valueOf(name) + names[i];
                names[i] = null;
                File fp = new File(target);
                if (fp.isDirectory()) {
                    fp = null;
                    ClientAction.commitToDir(target);
                } else {
                    fp = null;
                    if (FileUtil.getFileName(target).startsWith(".#MAACHANG_SYNC#")) {
                        String fileName = FileUtil.getFileName(target);
                        String destName = target.substring(0, target.length() - (fileName.length() + 1)) + FileUtil.FILE_SPACE + fileName.substring(".#MAACHANG_SYNC#".length());
                        if (FileUtil.isFileExists(destName)) {
                            FileUtil.removeFile(destName);
                        }
                        FileUtil.moveFile(target, destName);
                    }
                }
                ++i;
            }
        }
    }

    private static final void rollbackToDir(String name) throws Exception {
        int len;
        if (!name.endsWith("\\") && !name.endsWith("/")) {
            name = String.valueOf(name) + FileUtil.FILE_SPACE;
        }
        File file = new File(name);
        String[] names = file.list();
        file = null;
        if (names != null && (len = names.length) > 0) {
            int i = 0;
            while (i < len) {
                String target = String.valueOf(name) + names[i];
                names[i] = null;
                File fp = new File(target);
                if (fp.isDirectory()) {
                    fp = null;
                    ClientAction.rollbackToDir(target);
                } else {
                    fp = null;
                    if (FileUtil.getFileName(target).startsWith(".#MAACHANG_SYNC#") && FileUtil.isFileExists(target)) {
                        FileUtil.removeFile(target);
                    }
                }
                ++i;
            }
        }
    }

    private static final String getIpPort(Tcp tcp) {
        String ret = null;
        if (tcp == null || !tcp.isTcp()) {
            ret = "unknown/xxxxxx";
        } else {
            Socket sock = tcp.getSocket();
            ret = sock.getInetAddress().getHostAddress() + "/" + sock.getPort();
        }
        return ret;
    }
}

