/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.sync;

import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.sync.ClientAction;
import org.maachang.util.net.CreateSocket;

public class ClientMain {
    private static final Log LOG;
    private static final String PARAM_LOCAL_DIR = "-o";
    private static final String PARAM_REMOTE_DIR = "-d";
    private static final String PARAM_KEY = "-k";
    private static final String PARAM_REMOTE = "-r";
    private static final String PARAM_PORT = "-p";
    private static final String PARAM_ALL = "-all";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.maachang.sync.ClientMain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public static final void main(String[] args) throws Exception {
        new ClientMain().execution(args);
    }

    public void execution(String[] args) throws Exception {
        String localDir = ClientMain.getLocalDir(args);
        String remoteDir = ClientMain.getRemoteDir(args);
        String keyword = ClientMain.getKeyword(args);
        String remoteAddr = ClientMain.getRemote(args);
        int port = ClientMain.getPort(args);
        boolean allOpt = ClientMain.isAllOption(args);
        if (localDir == null || localDir.length() <= 0 || remoteDir == null || remoteDir.length() <= 0 || remoteAddr == null || remoteAddr.length() <= 0) {
            LOG.error((Object)"## \u5f15\u6570\u304c\u8db3\u308a\u307e\u305b\u3093");
            return;
        }
        LOG.info((Object)("## \u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u958b\u59cb MaachangSync#ClientMain[ localDir:" + localDir + " remoteDir:" + remoteDir + " keyword:" + keyword + " remoteAddr:" + remoteAddr + " port:" + port + " allOpt:" + allOpt + "]"));
        try {
            try {
                Socket socket = CreateSocket.clientSocket(InetAddress.getByName(remoteAddr), port);
                LOG.info((Object)("## addr:" + socket.getLocalAddress().getHostAddress() + " port:" + socket.getLocalPort()));
                ClientAction cl = new ClientAction(socket, localDir, remoteDir, keyword);
                cl.execution(allOpt);
            }
            catch (Exception e) {
                LOG.error((Object)"## \u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u30a8\u30e9\u30fc", (Throwable)e);
            }
        }
        finally {
            LOG.info((Object)"## \u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u7d42\u4e86.....");
        }
    }

    private static final String getLocalDir(String[] args) {
        if (args == null) {
            return null;
        }
        int len = args.length;
        int i = 0;
        while (i < len) {
            String name = args[i];
            if (name != null && (name = name.trim()).length() > 0 && name.toLowerCase().startsWith(PARAM_LOCAL_DIR)) {
                return name.substring(PARAM_LOCAL_DIR.length());
            }
            ++i;
        }
        return null;
    }

    private static final String getRemoteDir(String[] args) {
        if (args == null) {
            return null;
        }
        int len = args.length;
        int i = 0;
        while (i < len) {
            String name = args[i];
            if (name != null && (name = name.trim()).length() > 0 && name.toLowerCase().startsWith(PARAM_REMOTE_DIR)) {
                return name.substring(PARAM_REMOTE_DIR.length());
            }
            ++i;
        }
        return null;
    }

    private static final String getKeyword(String[] args) {
        if (args == null) {
            return "default-key";
        }
        int len = args.length;
        int i = 0;
        while (i < len) {
            String name = args[i];
            if (name != null && (name = name.trim()).length() > 0 && name.toLowerCase().startsWith(PARAM_KEY)) {
                return name.substring(PARAM_KEY.length());
            }
            ++i;
        }
        return "default-key";
    }

    private static final String getRemote(String[] args) {
        if (args == null) {
            return null;
        }
        int len = args.length;
        int i = 0;
        while (i < len) {
            String name = args[i];
            if (name != null && (name = name.trim()).length() > 0 && name.toLowerCase().startsWith(PARAM_REMOTE)) {
                return name.substring(PARAM_REMOTE.length());
            }
            ++i;
        }
        return null;
    }

    private static final int getPort(String[] args) {
        if (args == null) {
            return 23456;
        }
        int len = args.length;
        int i = 0;
        while (i < len) {
            String name = args[i];
            if (name != null && (name = name.trim()).length() > 0 && name.toLowerCase().startsWith(PARAM_PORT)) {
                String port = name.substring(PARAM_PORT.length());
                try {
                    int portInt = Integer.parseInt(port);
                    if (portInt >= 0 && portInt < 65535) {
                        return portInt;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return 23456;
    }

    private static final boolean isAllOption(String[] args) {
        if (args == null) {
            return false;
        }
        int len = args.length;
        int i = 0;
        while (i < len) {
            String name = args[i];
            if (name != null && (name = name.trim()).length() > 0 && name.toLowerCase().equals(PARAM_ALL)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

