/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.sync;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.sync.MaachangSyncProtocol;
import org.maachang.util.ConvertBinary;
import org.maachang.util.Encryption;
import org.maachang.util.FileUtil;
import org.maachang.util.net.CreateSocket;
import org.maachang.util.net.Tcp;

public class ServerAction
extends Thread {
    private static final Log LOG;
    private static final int ONE_SEND_LENGTH = 65484;
    private Tcp tcp = null;
    private byte[] keycode = null;
    private volatile boolean endFlg = false;
    private byte[] buffer = new byte[65535];
    private Encryption enc = new Encryption();
    private final Object sync = new Object();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.maachang.sync.ServerAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    private ServerAction() {
    }

    public ServerAction(Socket socket, String key) throws Exception {
        if (socket == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (key == null || key.length() <= 0) {
            key = "default-key";
        }
        this.tcp = CreateSocket.createTcp(socket);
        this.keycode = Encryption.convertStringByCode32Key(key);
        this.checkAccess();
        this.setDaemon(false);
        this.endFlg = false;
        this.start();
    }

    protected void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.sync;
        synchronized (object) {
            this.endFlg = true;
            if (this.tcp != null) {
                this.tcp.destroy();
            }
            this.tcp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThread() {
        boolean ret = true;
        Object object = this.sync;
        synchronized (object) {
            ret = !this.endFlg;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String ipPort = this.getIpPort();
        Object object = this.sync;
        synchronized (object) {
            this.endFlg = false;
            if (!this.tcp.isTcp()) {
                LOG.error((Object)"## \u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306b\u5931\u6557.....");
                return;
            }
        }
        try {
            try {
                this.execution(ipPort);
            }
            catch (Exception e) {
                LOG.error((Object)("## [" + ipPort + "]\u540c\u671f\u51e6\u7406\u3067\u30a8\u30e9\u30fc....."), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object object2 = this.sync;
            synchronized (object2) {
                this.endFlg = true;
                if (this.tcp != null) {
                    this.tcp.destroy();
                }
                this.tcp = null;
            }
            throw throwable;
        }
        Object object3 = this.sync;
        synchronized (object3) {
            this.endFlg = true;
            if (this.tcp != null) {
                this.tcp.destroy();
            }
            this.tcp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getIpPort() {
        String ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = ServerAction.getIpPort(this.tcp);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void execution(String ipPort) throws Exception {
        ArrayList lst = null;
        Tcp tcpip = null;
        byte[] key = null;
        Object object = this.sync;
        synchronized (object) {
            tcpip = this.tcp;
            key = this.keycode;
        }
        String[] targetDir = new String[1];
        long time = ServerAction.getLastUpdateTime(targetDir, tcpip, key, this.buffer, this.enc);
        String target = FileUtil.getFullPath(targetDir[0]);
        targetDir = null;
        LOG.info((Object)("## [" + ipPort + "](" + target + ")=\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306e\u6700\u7d42\u66f4\u65b0\u6642\u9593-" + time + "sec..."));
        if (!FileUtil.isDirExists(target)) {
            LOG.error((Object)("\u30ea\u30e2\u30fc\u30c8\u6307\u5b9a\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d(" + target + ")\u306f\u5b58\u5728\u3057\u306a\u3044\u304b\u4e0d\u6b63\u3067\u3059"));
            throw new Exception("\u30ea\u30e2\u30fc\u30c8\u6307\u5b9a\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d(" + target + ")\u306f\u5b58\u5728\u3057\u306a\u3044\u304b\u4e0d\u6b63\u3067\u3059");
        }
        lst = ServerAction.getSendFileNames(target, time);
        if (lst == null || lst.size() <= 0) {
            LOG.info((Object)("## [" + ipPort + "](" + target + ")=\u9001\u4fe1\u30d5\u30a1\u30a4\u30eb\u7dcf\u6570-\u306a\u3057"));
            ServerAction.exitSend(tcpip, key, 0, this.buffer, this.enc);
            return;
        }
        LOG.info((Object)("## [" + ipPort + "](" + target + ")=\u9001\u4fe1\u30d5\u30a1\u30a4\u30eb\u7dcf\u6570-" + lst.size() + "\u500b"));
        int len = lst.size();
        int i = 0;
        while (i < len) {
            String syncFile = (String)lst.get(i);
            LOG.info((Object)("## -- [" + ipPort + "](" + target + "," + i + ")=\u9001\u4fe1\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u540c\u671f-" + syncFile));
            ServerAction.sendFile(tcpip, key, target, syncFile, i, this.buffer, this.enc);
            Object object2 = this.sync;
            synchronized (object2) {
                if (this.endFlg) {
                    LOG.info((Object)("## ++ [" + ipPort + "](" + target + "," + i + ")=\u9001\u4fe1\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u540c\u671f\u7570\u5e38\u7d42\u4e86-" + syncFile));
                    break;
                }
            }
            ++i;
        }
        boolean rollback = false;
        Object object3 = this.sync;
        synchronized (object3) {
            if (this.endFlg) {
                rollback = true;
            }
        }
        if (!rollback) {
            ServerAction.exitSend(tcpip, key, len, this.buffer, this.enc);
            LOG.info((Object)("## [" + ipPort + "](" + target + ")=\u9001\u4fe1\u30d5\u30a1\u30a4\u30eb\u6b63\u5e38\u540c\u671f\u5b8c\u4e86-" + lst.size()));
        } else {
            LOG.error((Object)("## [" + ipPort + "](" + target + ")=\u9001\u4fe1\u30d5\u30a1\u30a4\u30eb\u7570\u5e38\u540c\u671f\u5b8c\u4e86-" + lst.size()));
        }
    }

    private static final String getIpPort(Tcp tcp) {
        String ret = null;
        if (tcp == null || !tcp.isTcp()) {
            ret = "unknown/xxxxxx";
        } else {
            Socket sock = tcp.getSocket();
            ret = sock.getInetAddress().getHostAddress() + "/" + sock.getPort();
        }
        return ret;
    }

    private static final long getLastUpdateTime(String[] out, Tcp tcp, byte[] keycode, byte[] buf, Encryption enc) throws Exception {
        int len = tcp.receive(buf, -1, 15000L);
        if (len <= 51) {
            throw new Exception("\u6700\u7d42\u66f4\u65b0\u65e5\u306e\u53d7\u4fe1\u9577\u304c\u4e0d\u6b63\u3067\u3059[" + len + "]");
        }
        byte[] header = MaachangSyncProtocol.getHeader(buf);
        if ((header[0] & 0xFF) != (MaachangSyncProtocol.HD_LAST_UPATE[0] & 0xFF) && (header[1] & 0xFF) != (MaachangSyncProtocol.HD_LAST_UPATE[1] & 0xFF)) {
            throw new Exception("\u6700\u7d42\u66f4\u65b0\u65e5\u306e\u30d8\u30c3\u30c0\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        byte[] key = MaachangSyncProtocol.getKey(buf);
        int code = MaachangSyncProtocol.getCode(buf);
        enc.create(keycode);
        enc.analysis(key, code, buf, 39, len - 39);
        int pnt = 39;
        long ret = ConvertBinary.convertLong(pnt, buf);
        int targetLen = ConvertBinary.convertInt(pnt += 8, buf);
        pnt += 4;
        if (targetLen <= 0 || targetLen + 51 > len) {
            throw new Exception("\u30bf\u30fc\u30b2\u30c3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d\u9577\u304c\u4e0d\u6b63\u3067\u3059[" + targetLen + "]");
        }
        byte[] nameBin = new byte[targetLen];
        System.arraycopy(buf, pnt, nameBin, 0, targetLen);
        out[0] = new String(nameBin, "UTF8");
        nameBin = null;
        return ret;
    }

    private static final ArrayList getSendFileNames(String targetDir, long lastTime) throws Exception {
        ArrayList ret = new ArrayList();
        FileUtil.getDirectoryToTargetNextTime(ret, targetDir, lastTime);
        if (ret.size() <= 0) {
            return null;
        }
        return ret;
    }

    private static final void sendFile(Tcp tcp, byte[] keycode, String targetDir, String sendName, int no, byte[] buf, Encryption enc) throws Exception {
        BufferedInputStream bi = null;
        try {
            long fsz = FileUtil.getLength(sendName);
            enc.create(keycode);
            int len = ServerAction.getFirstSendFile(buf, targetDir, sendName, fsz, no, enc);
            tcp.send(buf, 0, len);
            tcp.flush();
            bi = new BufferedInputStream(new FileInputStream(sendName));
            int i = 0;
            while (true) {
                enc.create(keycode);
                int one = ServerAction.getSyncOneFile(buf, bi, no, i, fsz, enc);
                tcp.send(buf, 0, one);
                tcp.flush();
                if ((fsz -= (long)(one - 51)) <= 0L) {
                    break;
                }
                ++i;
            }
        }
        finally {
            if (bi != null) {
                try {
                    bi.close();
                }
                catch (Exception exception) {}
            }
            bi = null;
        }
    }

    private static final void exitSend(Tcp tcp, byte[] keycode, int length, byte[] buf, Encryption enc) throws Exception {
        enc.create(keycode);
        int len = ServerAction.getEndSendFile(buf, length, enc);
        tcp.send(buf, 0, len);
        tcp.flush();
    }

    private static final int getFirstSendFile(byte[] buf, String targetDir, String sendName, long fsz, int no, Encryption enc) throws Exception {
        int pnt = 0;
        String name = sendName.substring(targetDir.length());
        if (name.startsWith("/") || name.startsWith("\\")) {
            name = name.substring(1);
        }
        byte[] fnm = name.getBytes("UTF8");
        buf[0] = MaachangSyncProtocol.HD_SYNC_START_FILE[0];
        buf[1] = MaachangSyncProtocol.HD_SYNC_START_FILE[1];
        pnt += 2;
        byte[] key = Encryption.getPublicKey();
        System.arraycopy(key, 0, buf, 2, 32);
        int next = pnt += 37;
        ConvertBinary.convertInt(buf, pnt, no);
        ConvertBinary.convertLong(buf, pnt += 4, fsz);
        ConvertBinary.convertInt(buf, pnt += 8, fnm.length);
        System.arraycopy(fnm, 0, buf, pnt += 4, fnm.length);
        int code = enc.encryption(key, buf, next, (pnt += fnm.length) - next);
        buf[34] = (byte)(code & 0xFF);
        ConvertBinary.convertInt(buf, 35, pnt);
        return pnt;
    }

    private static final int getSyncOneFile(byte[] buf, InputStream bi, int no, int seq, long all, Encryption enc) throws Exception {
        int pnt = 0;
        buf[0] = MaachangSyncProtocol.HD_SYNC_FILE[0];
        buf[1] = MaachangSyncProtocol.HD_SYNC_FILE[1];
        pnt += 2;
        byte[] key = Encryption.getPublicKey();
        System.arraycopy(key, 0, buf, 2, 32);
        int next = pnt += 37;
        ConvertBinary.convertInt(buf, pnt, no);
        ConvertBinary.convertInt(buf, pnt += 4, seq);
        int oneLen = all > 65484L ? 65484 : (int)all;
        ConvertBinary.convertInt(buf, pnt += 4, oneLen);
        bi.read(buf, pnt += 4, oneLen);
        int code = enc.encryption(key, buf, next, (pnt += oneLen) - next);
        buf[34] = (byte)(code & 0xFF);
        ConvertBinary.convertInt(buf, 35, pnt);
        return pnt;
    }

    private static final int getEndSendFile(byte[] buf, int length, Encryption enc) throws Exception {
        int pnt = 0;
        buf[0] = MaachangSyncProtocol.HD_END[0];
        buf[1] = MaachangSyncProtocol.HD_END[1];
        pnt += 2;
        byte[] key = Encryption.getPublicKey();
        System.arraycopy(key, 0, buf, 2, 32);
        int next = pnt += 37;
        ConvertBinary.convertInt(buf, pnt, length);
        int code = enc.encryption(key, buf, next, (pnt += 4) - next);
        buf[34] = (byte)(code & 0xFF);
        ConvertBinary.convertInt(buf, 35, pnt);
        return pnt;
    }
}

