/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.sync;

import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.sync.ServerAction;
import org.maachang.util.net.CreateSocket;

public class ServerMain {
    private static final Log LOG;
    private static final int ACCEPT_TIMEOUT = 50;
    private static final int OPEN_CHECK_TIMING = 15;
    private static final String PARAM_KEY = "-k";
    private static final String PARAM_PORT = "-p";
    private static final String PARAM_ADDR = "-a";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.maachang.sync.ServerMain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public static final void main(String[] args) throws Exception {
        new ServerMain().execution(args);
    }

    public void execution(String[] args) throws Exception {
        String keyword = ServerMain.getKeyword(args);
        int port = ServerMain.getPort(args);
        String address = ServerMain.getAddress(args);
        ArrayList<ServerAction> cl = null;
        LOG.info((Object)("## \u30b5\u30fc\u30d0\u958b\u59cb MaachangSync#ServerMain[ keyword:" + keyword + " port:" + port + " address:" + address + "]"));
        try {
            try {
                InetAddress addr = address == null ? null : InetAddress.getByName(address);
                ServerSocket serverSocket = CreateSocket.serverSocket(port, addr, 5);
                serverSocket.setSoTimeout(50);
                addr = null;
                LOG.info((Object)("## addr:" + serverSocket.getInetAddress().getHostAddress() + " port:" + serverSocket.getLocalPort()));
                cl = new ArrayList<ServerAction>();
                int i = 0;
                while (true) {
                    ServerAction sa;
                    try {
                        Socket conn = serverSocket.accept();
                        if (conn != null) {
                            LOG.info((Object)("## accept:" + conn.getLocalAddress().getHostAddress() + " port:" + conn.getLocalPort()));
                            sa = new ServerAction(conn, keyword);
                            cl.add(sa);
                        }
                    }
                    catch (InterruptedIOException conn) {
                        // empty catch block
                    }
                    if (i >= 15) {
                        i = -1;
                        int j = cl.size() - 1;
                        while (j >= 0) {
                            sa = (ServerAction)cl.get(j);
                            if (sa == null || !sa.isThread()) {
                                cl.remove(j);
                                if (sa != null) {
                                    sa.clear();
                                    sa = null;
                                }
                            }
                            --j;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                LOG.error((Object)"## \u30b5\u30fc\u30d0\u30a8\u30e9\u30fc", (Throwable)e);
            }
        }
        finally {
            LOG.info((Object)"## \u30b5\u30fc\u30d0\u7d42\u4e86.....");
            if (cl != null) {
                cl.clear();
            }
        }
    }

    private static final String getKeyword(String[] args) {
        if (args == null) {
            return "default-key";
        }
        int len = args.length;
        int i = 0;
        while (i < len) {
            String name = args[i];
            if (name != null && (name = name.trim()).length() > 0 && name.toLowerCase().startsWith(PARAM_KEY)) {
                return name.substring(PARAM_KEY.length());
            }
            ++i;
        }
        return "default-key";
    }

    private static final int getPort(String[] args) {
        if (args == null) {
            return 23456;
        }
        int len = args.length;
        int i = 0;
        while (i < len) {
            String name = args[i];
            if (name != null && (name = name.trim()).length() > 0 && name.toLowerCase().startsWith(PARAM_PORT)) {
                String port = name.substring(PARAM_PORT.length());
                try {
                    int portInt = Integer.parseInt(port);
                    if (portInt >= 0 && portInt < 65535) {
                        return portInt;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return 23456;
    }

    private static final String getAddress(String[] args) {
        if (args == null) {
            return null;
        }
        int len = args.length;
        int i = 0;
        while (i < len) {
            String name = args[i];
            if (name != null && (name = name.trim()).length() > 0 && name.toLowerCase().startsWith(PARAM_ADDR)) {
                return name.substring(PARAM_ADDR.length());
            }
            ++i;
        }
        return null;
    }
}

