/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

public class ByteUtil {
    private byte[] binary = null;
    private int length = 0;

    public void clear() {
        this.binary = null;
        this.length = 0;
    }

    public void add(byte[] binary, int offset, int length) {
        int len;
        if (binary == null || (len = binary.length) <= 0 || offset >= len) {
            return;
        }
        if (length <= 0) {
            length = len;
        }
        if (offset + length >= len) {
            length = len - offset;
        }
        if (this.binary == null || this.binary.length <= 0) {
            this.binary = new byte[length];
            this.length = length;
            System.arraycopy(binary, offset, this.binary, 0, length);
        } else {
            byte[] tmp = new byte[this.length + length];
            System.arraycopy(this.binary, 0, tmp, 0, this.length);
            System.arraycopy(binary, offset, tmp, this.length, length);
            this.binary = tmp;
            this.length = this.binary.length;
        }
    }

    public void remove(int length) {
        if (length >= this.length) {
            this.binary = null;
            this.length = 0;
        } else {
            int len = this.length - length;
            byte[] tmp = new byte[len];
            System.arraycopy(this.binary, length, tmp, 0, len);
            this.binary = tmp;
            this.length = len;
        }
    }

    public int get(byte[] out) {
        int len;
        if (out == null || (len = out.length) <= 0) {
            return -1;
        }
        if (this.binary == null || this.length <= 0) {
            return -1;
        }
        if (len >= this.length) {
            len = this.length;
        }
        System.arraycopy(this.binary, 0, out, 0, len);
        return len;
    }

    public int size() {
        return this.length;
    }
}

