/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class FileUtil {
    public static final String FILE_SPACE = System.getProperty("file.separator");

    public static final String mkdirs(String dirName) throws IOException {
        File fp = null;
        StringBuffer buf = null;
        String tmp = null;
        String ret = null;
        try {
            if (dirName == null) {
                throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (FileUtil.isDirExists(dirName)) {
                fp = new File(dirName);
                tmp = fp.getCanonicalPath();
                buf = new StringBuffer();
                buf.append(tmp);
                buf.append(FILE_SPACE);
                ret = buf.toString();
            } else {
                fp = new File(dirName);
                tmp = fp.getCanonicalPath();
                buf = new StringBuffer();
                buf.append(tmp);
                buf.append(FILE_SPACE);
                ret = buf.toString();
                if (!fp.mkdirs()) {
                    throw new IOException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea(" + dirName + ")\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                }
            }
        }
        finally {
            fp = null;
            buf = null;
            tmp = null;
        }
        return ret;
    }

    public static final String getFullPath(String path) throws IOException {
        File fp = new File(path);
        return fp.getCanonicalPath();
    }

    public static final String getFileName(String path) {
        int p = path.lastIndexOf("\\");
        int p2 = path.lastIndexOf("/");
        if (p == -1) {
            if (p2 != -1) {
                p = p2;
            }
        } else if (p2 != -1 && p < p2) {
            p = p2;
        }
        if (p == -1) {
            return path;
        }
        return path.substring(p + 1);
    }

    public static final String cutSeparator(boolean mode, String name) {
        if (mode) {
            if ((name = name.trim()).startsWith("/") || name.startsWith("\\")) {
                return name.substring(1);
            }
        } else if ((name = name.trim()).endsWith("/") || name.endsWith("\\")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static final void removeFile(String name) {
        try {
            File file = new File(name);
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void moveFile(String src, String dest) {
        try {
            File fileSrc = new File(src);
            File fileDest = new File(dest);
            fileSrc.renameTo(fileDest);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final long getLength(String name) {
        long ret = -1L;
        try {
            File file = new File(name);
            ret = file.exists() ? file.length() : -1L;
        }
        catch (Exception e) {
            ret = -1L;
        }
        return ret;
    }

    public static final long getLastTime(String name) {
        long ret = 0L;
        try {
            File file = new File(name);
            ret = file.exists() ? file.lastModified() : 0L;
        }
        catch (Exception e) {
            ret = 0L;
        }
        return ret;
    }

    public static final boolean isFileExists(String name) {
        boolean ret;
        if (name == null || name.length() <= 0) {
            return false;
        }
        try {
            File file = new File(name);
            ret = file.exists() ? (!file.isDirectory() ? file.canRead() : false) : false;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static final boolean isDirExists(String dirName) {
        File check = null;
        if (dirName == null) {
            return false;
        }
        check = new File(dirName);
        boolean ret = check.isDirectory();
        check = null;
        return ret;
    }

    public static final boolean isRead(String name) {
        boolean ret;
        File file = null;
        if (name == null || name.length() <= 0) {
            return false;
        }
        try {
            try {
                file = new File(name);
                ret = file.canRead();
            }
            catch (Exception e) {
                ret = false;
            }
        }
        finally {
            file = null;
        }
        return ret;
    }

    public static final boolean isWrite(String name) {
        File check = null;
        if (name == null) {
            return false;
        }
        check = new File(name);
        boolean ret = check.canWrite();
        check = null;
        return ret;
    }

    public static final long getDirectoryToLastTime(String name) {
        if (!FileUtil.isDirExists(name)) {
            return -1L;
        }
        return FileUtil.lastUpdateByDirectory(name, -1L);
    }

    public static final void getDirectoryToTargetNextTime(ArrayList out, String name, long targetTime) {
        if (!FileUtil.isDirExists(name)) {
            return;
        }
        FileUtil.targetNextUpdateByDirectory(out, name, targetTime);
    }

    private static final long lastUpdateByDirectory(String name, long ret) {
        int len;
        if (!name.endsWith("\\") && !name.endsWith("/")) {
            name = String.valueOf(name) + FILE_SPACE;
        }
        File file = new File(name);
        String[] names = file.list();
        file = null;
        if (names != null && (len = names.length) > 0) {
            int i = 0;
            while (i < len) {
                String target = String.valueOf(name) + names[i];
                names[i] = null;
                File fp = new File(target);
                if (fp.isDirectory()) {
                    fp = null;
                    ret = FileUtil.lastUpdateByDirectory(target, ret);
                } else {
                    long now = fp.lastModified();
                    fp = null;
                    if (!FileUtil.getFileName(target).startsWith(".#MAACHANG_SYNC#") && now > ret) {
                        ret = now;
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    private static final void targetNextUpdateByDirectory(ArrayList lst, String name, long targetTime) {
        int len;
        if (!name.endsWith("\\") && !name.endsWith("/")) {
            name = String.valueOf(name) + FILE_SPACE;
        }
        File file = new File(name);
        String[] names = file.list();
        file = null;
        if (names != null && (len = names.length) > 0) {
            int i = 0;
            while (i < len) {
                String target = String.valueOf(name) + names[i];
                names[i] = null;
                File fp = new File(target);
                if (fp.isDirectory()) {
                    fp = null;
                    FileUtil.targetNextUpdateByDirectory(lst, target, targetTime);
                } else {
                    long now = fp.lastModified();
                    fp = null;
                    if (!FileUtil.getFileName(target).startsWith(".#MAACHANG_SYNC#") && now > targetTime) {
                        lst.add(new String(target));
                    }
                }
                ++i;
            }
        }
    }
}

