/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.net;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.maachang.util.net.Tcp;

public class CreateSocket {
    public static final int BUFFER_LENGTH = 512;
    public static final int NEW_RECEIVE_TIMEOUT_COUNT = 64;
    public static final int RECV_TIMEOUT = 30;
    public static final int BASE_BUFFER = 262144;
    private static final int DEFAULT_MAX_ACCESS = 50;

    public static final ServerSocket serverSocket(int bindPort, InetAddress bindAddress, int backlog) throws Exception {
        if (backlog <= 0) {
            backlog = 50;
        }
        return new ServerSocket(bindPort, backlog, bindAddress);
    }

    public static final Socket clientSocket(InetAddress address, int port) throws Exception {
        return new Socket(address, port);
    }

    public static final Tcp createTcp(Socket socket) throws Exception {
        if (socket == null || socket.isClosed()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        socket.setSendBufferSize(262144);
        socket.setReceiveBufferSize(262144);
        socket.setSoTimeout(30);
        socket.setSoLinger(true, 1);
        socket.setKeepAlive(true);
        socket.setTcpNoDelay(true);
        socket.setReuseAddress(true);
        Tcp tcp = new Tcp(socket);
        return tcp;
    }
}

