/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import org.maachang.util.net.ReceiveTimeoutException;

public class Tcp {
    private Socket socket = null;
    private BufferedOutputStream sendBuffer = null;
    private BufferedInputStream receiveBuffer = null;

    private Tcp() {
    }

    public Tcp(Socket socket) throws Exception {
        if (socket == null || socket.isClosed()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.socket = socket;
        this.sendBuffer = new BufferedOutputStream(socket.getOutputStream());
        this.receiveBuffer = new BufferedInputStream(socket.getInputStream());
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.socket != null) {
            try {
                this.sendBuffer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.receiveBuffer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
        this.sendBuffer = null;
        this.receiveBuffer = null;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public InputStream getInputStream() {
        return this.receiveBuffer;
    }

    public OutputStream getOutputStream() {
        return this.sendBuffer;
    }

    public void flush() throws Exception {
        if (this.sendBuffer != null) {
            this.sendBuffer.flush();
        }
    }

    public void send(byte[] binary, int offset, int length) throws Exception {
        int len;
        if (binary == null || (len = binary.length) <= 0 || offset >= len) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (offset <= 0) {
            offset = 0;
        }
        if (length <= 0 || length >= len) {
            length = len;
        }
        if (offset + length >= len) {
            length = len - offset;
        }
        this.sendBuffer.write(binary, offset, length);
    }

    public int receive(byte[] binary, int length, long timeout) throws ReceiveTimeoutException, Exception {
        int len;
        if (binary == null || (len = binary.length) <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (length <= 0 || length >= len) {
            length = len;
        }
        int ret = 0;
        long tm = -1L;
        if (timeout > 0L) {
            tm = System.currentTimeMillis() + timeout;
        }
        boolean success = false;
        do {
            if (tm > -1L && tm <= System.currentTimeMillis()) {
                throw new ReceiveTimeoutException("\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3092\u691c\u77e5");
            }
            try {
                ret = this.receiveBuffer.read(binary, 0, length);
                success = true;
            }
            catch (InterruptedIOException ii) {
                ret = -1;
                success = false;
            }
            catch (Exception e) {
                throw e;
            }
        } while (!success);
        return ret;
    }

    public boolean isTcp() {
        boolean ret = false;
        try {
            ret = this.socket.isClosed();
            ret = !ret;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }
}

