/*
 * @(#)DestructObjectException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.exception;

/**
 * オブジェクト破棄時例外処理.  
 * <BR><BR>
 * オブジェクトの破棄時[ObjectBase#destruct()]に何らかの
 * 例外が発生した場合に、発生します.
 *  
 * @version 1.0.0 2003/10/31
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class DestructObjectException extends AccessException
{
    /**
     * コンタストラクタ.
     */
    public DestructObjectException()
    {
        super() ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public DestructObjectException(Throwable e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public DestructObjectException(BaseException e)
    {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public DestructObjectException(String message)
    {
        super(message) ;
    }
}
