/*
 * @(#)IODef.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.io;

import org.maachang.commons.sys.GetEnvironment;
import org.maachang.commons.util.ArrayTable;
import org.maachang.commons.util.UtilCom;


/**
 * I/O定義.
 *
 * @version 1.00, 2005/05/09
 * @author  Masahito Suzuki
 * @since   JRcCommons 1.00
 */
public class IODef
{
    
    /**
     * プロトコル名 : FTP.
     */
    public static final String PROTOCOL_FTP = "ftp" ;
    
    /**
     * プロトコル名 : HTTP.
     */
    public static final String PROTOCOL_HTTP = "http" ;
    
    /**
     * プロトコル名 : HTTPS.
     */
    public static final String PROTOCOL_HTTPS = "https" ;
    
    
    /**
     * プロトコルタイプ : 通常のローカルファイル.
     */
    public static final int TYPE_PROTOCOL_LOCAL = 0x00000000 ;
    
    /**
     * プロトコルタイプ : FTP.
     */
    public static final int TYPE_PROTOCOL_FTP = 0x00000001 ;
    
    /**
     * プロトコルタイプ : HTTP.
     */
    public static final int TYPE_PROTOCOL_HTTP = 0x00000010 ;
    
    /**
     * プロトコルタイプ : HTTPS.
     */
    public static final int TYPE_PROTOCOL_HTTPS = 0x00000020 ;
    
    /**
     * デフォルトFTPポート番号.
     */
    public static final int FTP_PORT = 21 ;
    
    /**
     * デフォルトHTTPポート番号.
     */
    public static final int HTTP_PORT = 80 ;
    
    /**
     * デフォルトHTTPSポート番号.
     */
    public static final int HTTPS_PORT = 443 ;
    
    /**
     * EOFコード.
     */
    public static final int EOF = -1 ;
    
    
    
    /**
     * 指定名からプロトコルを取得.
     * <BR><BR>
     * 指定名からプロトコルを取得します.
     * <BR>
     * @param name 対象名を設定します.
     * @return int プロトコルタイプが返されます.<BR>
     *             [IODef.TYPE_PROTOCOL_LOCAL]が返された場合
     *             プロトコル名でないか不明です.<BR>
     *             [IODef.TYPE_PROTOCOL_FTP]が返された場合
     *             プロトコル名はFTPです.<BR>
     *             [IODef.TYPE_PROTOCOL_HTTP]が返された場合
     *             プロトコル名はHTTPです.<BR>
     *             [IODef.TYPE_PROTOCOL_HTTPS]が返された場合
     *             プロトコル名はHTTPSです.
     */
    public static final int getNameByProtocolType( String name )
    {
        int ret ;
        
        ret = IODef.TYPE_PROTOCOL_LOCAL ;
        
        try{
            
            name = name.trim().toLowerCase() ;
            
            if( name.startsWith( IODef.PROTOCOL_FTP ) == true ){
                ret = IODef.TYPE_PROTOCOL_FTP ;
            }
            else if( name.startsWith( IODef.PROTOCOL_HTTP ) == true ){
                ret = IODef.TYPE_PROTOCOL_HTTP ;
            }
            else if( name.startsWith( IODef.PROTOCOL_HTTPS ) == true ){
                ret = IODef.TYPE_PROTOCOL_HTTPS ;
            }
            
        }catch( Exception e ){
            ret = IODef.TYPE_PROTOCOL_LOCAL ;
        }
        
        return ret ;
    }
    
    /**
     * 対象ファイル名を変換します.
     * <BR><BR>
     * 対象のファイル名を変換します.<BR>
     * この処理は、設定値に対して環境変数が設定されている場合、
     * その条件に対して変換を行います.
     * <BR>
     * @param name 変換対象のファイル名を設定します.
     * @return String 変換されたファイル名が返されます.
     */
    public static final String convertEnvName( String name )
    {
        String ret = null ;
        
        try{
            ret = IODef.trimFileName( IODef.convertEnvironmentByName( name ) ) ;
        }catch( Exception e ){
            ret = name ;
        }
        
        return ret ;
    }
    
    /**
     * ファイル名を整頓.
     * <BR><BR>
     * ファイル名を整頓します.
     * <BR>
     * @param name 整頓対象のファイル名を設定します.
     * @return String 整頓されたファイル名が返されます.
     */
    public static final String trimFileName( String name )
    {
        int i ;
        int len ;
        int colPnt ;
        int cat ;
        char one ;
        
        StringBuffer buf = null ;
        String ret ;
        
        if( name == null || ( len = name.length() ) <= 0 ){
            return null ;
        }
        else if(
            name.indexOf( "\\" ) == -1 &&
            name.indexOf( "/" ) == -1
        )
        {
            return name ;
        }
        
        try{
            
            name = name.trim() ;
            buf = new StringBuffer( len ) ;
            
            for( i = 0,colPnt = -1,cat = 0 ; i < len ; i ++ ){
                
                one = name.charAt( i ) ;
                
                colPnt = ( one == ':' ) ? i+1 : colPnt ;
                
                if( one == '\\' || one == '/' ){
                    
                    if( cat > 0 && colPnt != -1 ){
                        if( ( i - colPnt ) == cat && cat == 1 ){
                            buf.append( '/' ) ;
                        }
                    }
                    else{
                        buf.append( '/' ) ;
                    }
                    
                    cat ++ ;
                }
                else{
                    buf.append( one ) ;
                    cat = 0 ;
                }
            }
            
            ret = buf.toString() ;
            buf = null ;
            
            if( IODef.getNameByProtocolType( ret ) == TYPE_PROTOCOL_LOCAL ){
                ret = ( ret.startsWith( "/" ) == false ) ? ( "/" + ret ) : ret ;
            }
            
        }catch( Exception e ){
            ret = name ;
        }finally{
            buf = null ;
        }
        
        return ret ;
    }
    
    /**
     * 環境変数条件を含む文字列を変換.
     * <BR><BR>
     * 環境変数条件を含む文字列を変換します.
     * <BR>
     * @param str 変換対象の文字列を設定します.
     * @return String 変換された文字列が返されます.
     */
    public static final String convertEnvironmentByName( String str )
    {
        int i ;
        int len ;
        int pnt ;
        int nxt ;
        int end ;
        
        int stLen ;
        int edLen ;
        
        ArrayTable tbl = null ;
        StringBuffer buf = null ;
        String tmp = null ;
        String ret = null ;
        
        if( str == null || ( len = str.length() ) <= 0 ){
            return null ;
        }
        
        if( str.indexOf( "$(" ) == -1 ){
            return str ;
        }
        
        stLen = "$(".length() ;
        edLen = ")".length() ;
        
        tbl = GetEnvironment.getInstance().getTable() ;
        buf = new StringBuffer() ;
        
        try{
            
            for( i = 0,pnt = 0,nxt = 0,end = 0 ; i < len ; i ++ ){
                
                if(
                    ( nxt = str.indexOf( "$(",pnt ) ) != -1 &&
                    ( end = str.indexOf( ")",nxt ) ) != -1
                )
                {
                    if( pnt != nxt ){
                        buf.append( str.substring( pnt,nxt ) ) ;
                    }
                    
                    tmp = str.substring( nxt+stLen,end ) ;
                    
                    if( tmp != null && tmp.length() > 0 ){
                        
                        tmp = UtilCom.trimPlus( tmp ) ;
                        
                        if( tmp.length() > 0 ){
                            
                            if( tbl.isData( tmp ) == true ){
                                tmp = ( String )tbl.get( tmp,0 ) ;
                            }
                            else{
                                tmp = null ;
                            }
                            
                            if( tmp != null ){
                                buf.append( tmp ) ;
                            }
                            
                            tmp = null ;
                            
                        }
                        
                    }
                    
                    pnt = end+edLen ;
                    
                }
                else{
                    buf.append( str.substring( pnt,len ) ) ;
                    break ;
                }
                
            }
            
            ret = buf.toString() ;
            
        }catch( Exception e ){
            ret = str ;
        }finally{
            buf = null ;
            tmp = null ;
            tbl = null ;
        }
        
        return ret ;
    }
    
    
    
    private IODef(){}

}

