/*
 * @(#)ConnectTimeoutException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.net;

import org.maachang.commons.exception.BaseException;

/**
 * コネクションタイムアウト例外.
 *  
 * @version 1.0.0 2003/12/10
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class ConnectTimeoutException extends CommunicateException
{
    /**
     * コンタストラクタ.
     */
    public ConnectTimeoutException()
    {
        super( CommunicateException.TIME_OUT ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public ConnectTimeoutException(Throwable e)
    {
        super( e,CommunicateException.TIME_OUT ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public ConnectTimeoutException(BaseException e)
    {
        super( e,CommunicateException.TIME_OUT ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public ConnectTimeoutException(String message)
    {
        super( CommunicateException.TIME_OUT,message ) ;
        
    }
}
