/*
 * @(#)NotLoginException.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.net;

import org.maachang.commons.exception.AccessException;
import org.maachang.commons.exception.BaseException;

/**
 * ログイン失敗例外処理.
 *  
 * @version 1.0.0 2005/05/07
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class NotLoginException extends AccessException
{
    /**
     * コンタストラクタ.
     */
    public NotLoginException()
    {
        super() ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NotLoginException(Throwable e)
    {
        super(e.getLocalizedMessage()) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public NotLoginException(BaseException e)
    {
        super(e.getLocalizedMessage()) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public NotLoginException(String message)
    {
        super(message) ;
    }
}
