/*
 * @(#)TelegramValue.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.net;

import java.net.InetAddress;

import org.maachang.commons.resource.BinResource;


/**
 * 電文要素.
 * <BR><BR>
 * 電文要素を持つオブジェクトです.
 *
 * @version     1.00, 2005/07/26
 * @author      Masahito Suzuki
 * @since   JRcCommons 1.00
 */
public class TelegramValue
{
    
    /**
     * オブジェクト有効フラグ.
     */
    private boolean m_useFlg = false ;
    
    /**
     * ID情報.
     */
    private int m_id = -1 ;
    
    /**
     * アドレス情報.
     */
    private InetAddress m_addr = null ;
    
    /**
     * ポート番号.
     */
    private int m_port = -1 ;
    
    /**
     * バイナリ情報.
     */
    private Object m_bin = null ;
    
    /**
     * 再送カウント.
     */
    private int m_resendCnt = -1 ;
    
    /**
     * コンストラクタ.
     */
    public TelegramValue()
    {
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        this.clear() ;
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public synchronized final void clear()
    {
        if( m_bin != null && m_bin instanceof BinResource ){
            ( ( BinResource )m_bin ).clear() ;
        }
        m_useFlg = false ;
        m_id = -1 ;
        m_addr = null ;
        m_port = -1 ;
        m_bin = null ;
        m_resendCnt = -1 ;
    }
    
    /**
     * オブジェクトを有効に設定.
     * <BR><BR>
     * オブジェクトを有効に設定します.
     */
    public synchronized final void setUse()
    {
        m_useFlg = true ;
    }
    
    /**
     * ID情報を設定.
     * <BR><BR>
     * 対象のID情報を設定します.
     * <BR>
     * @param id 対象のID情報を設定します.
     */
    public synchronized final void setID( int id )
    {
        m_id = id ;
    }
    
    /**
     * ID情報を取得.
     * <BR><BR>
     * 対象のID情報を取得します.
     * <BR>
     * @return int 対象のID情報が返されます.
     */
    public synchronized final int getID()
    {
        return m_id ;
    }
    
    /**
     * バイナリ情報を設定.
     * <BR><BR>
     * 対象のバイナリ情報を設定します.
     * <BR>
     * @param binary 対象のバイナリ情報を設定します.
     */
    public synchronized final void setBinary( Object binary )
    {
        if( m_bin != null && m_bin instanceof BinResource ){
            ( ( BinResource )m_bin ).clear() ;
            m_bin = null ;
        }
        m_bin = binary ;
    }
    
    /**
     * バイナリ情報を取得.
     * <BR><BR>
     * 設定されているバイナリ情報を取得します.<BR>
     * また１度取得した場合、バイナリ情報はクリアされます.
     * <BR>
     * @return Object 設定されているバイナリ情報が返されます.
     */
    public synchronized final Object getBinary()
    {
        Object ret = null ;
        
        ret = m_bin ;
        m_bin = null ;
        
        return ret ;
    }
    
    /**
     * 対象アドレス情報を設定.
     * <BR><BR>
     * 対象アドレス情報を設定します.
     * <BR>
     * @param addr 対象のアドレス情報を設定します.
     */
    public synchronized final void setAddress( InetAddress addr )
    {
        m_addr = addr ;
    }
    
    /**
     * 対象のアドレス情報を取得.
     * <BR><BR>
     * 対象のアドレス情報を取得します.
     * <BR>
     * @return InetAddress 対象のアドレス情報が返されます.
     */
    public synchronized final InetAddress getAddress()
    {
        return m_addr ;
    }
    
    /**
     * 対象のポート番号を設定.
     * <BR><BR>
     * 対象のポート番号を設定します.
     * <BR>
     * @param port 対象のポート番号を設定します.
     */
    public synchronized final void setPort( int port )
    {
        m_port = port ;
    }
    
    /**
     * 対象のポート番号を取得.
     * <BR><BR>
     * 対象のポート番号を取得します.
     * <BR>
     * @return int 対象のポート番号を取得します.
     */
    public synchronized final int getPort()
    {
        return m_port ;
    }
    
    /**
     * 再送カウントを設定.
     * <BR><BR>
     * 再送カウントを設定します.
     * <BR>
     * @param cnt 対象の再送カウントを設定します.
     */
    public synchronized final void setResendCount( int cnt )
    {
        m_resendCnt = cnt ;
    }
    
    /**
     * 対象の再送カウントを取得.
     * <BR><BR>
     * 対象の再送カウントを取得します.
     * <BR>
     * @return int 対象の再送カウントを取得します.
     */
    public synchronized final int getResendCount()
    {
        return m_resendCnt ;
    }
    
    /**
     * 有効可能チェック.
     * <BR><BR>
     * このオブジェクトが現在有効であるかチェックします.
     * <BR>
     * @return boolean このオブジェクトが有効であるかチェックします.<BR>
     *                 [true]が返された場合有効です.<BR>
     *                 [false]が返された場合無効です.
     */
    public synchronized final boolean isUse()
    {
        return m_useFlg ;
    }
    
}

