/*
 * @(#)SectorSizeManage.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.resource.cache;

import java.io.Serializable;

import org.maachang.commons.serialize.SerializeUtil;



/**
 * セクタに対するサイズを管理.
 *  
 * @version 2006/08/29
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class SectorSizeManage implements Serializable {
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            SectorSizeManage.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * 管理テーブル.
     */
    private int[] table = null ;
    
    /**
     * コンストラクタ.
     */
    private SectorSizeManage() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * セクタサイズを設定して、オブジェクトを生成します.
     * <BR>
     * @param size 対象のセクタサイズを設定します.
     */
    public SectorSizeManage( int size ) {
        
        if ( size <= SectorIDManage.MIN_SECTOR ) {
            size = SectorIDManage.MIN_SECTOR ;
        }
        else if ( size >= SectorIDManage.MAX_SECTOR ) {
            size = SectorIDManage.MAX_SECTOR ;
        }
        
        table = new int[ size ] ;
        
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception {
        
        try {
            this.destroy() ;
        } catch ( Exception t ) {
            
        }
    }
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * オブジェクトを破棄します.
     */
    public synchronized void destroy() {
        table = null ;
    }
    
    /**
     * 利用IDに対してデータ長を設定.
     * <BR><BR>
     * 利用IDに対してデータ長を設定します.
     * <BR>
     * @param useID 対象の利用IDを設定します.
     * @param size 対象のデータ長を設定します.
     */
    public synchronized void set( int useID,int size ) {
        
        if( table == null || useID < 0 || useID >= table.length || size < 0 ) {
            return ;
        }
        
        table[ useID ] = size ;
    }
    
    /**
     * 利用IDに対するデータ長を取得.
     * <BR><BR>
     * 利用IDに対するデータ長を取得します.
     * <BR>
     * @param useID 対象の利用IDを設定します.
     * @return int データ長が返されます.
     */
    public synchronized int get( int useID ) {
        
        if( table == null || useID < 0 || useID >= table.length ) {
            return -1 ;
        }
        
        return table[ useID ] ;
    }
    
}

