/** 
 * @(#)DataMap.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.commons.util ;

import java.io.Serializable;
import java.util.HashMap;

import org.maachang.commons.exception.InputException;
import org.maachang.commons.serialize.SerializeUtil;
import org.maachang.commons.util.array.ObjectArray;


/**
 * データMapオブジェクト.
 *
 * @version 2006/09/24
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class DataMap implements Serializable
{
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            DataMap.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * データ格納オブジェクト.
     */
    private ObjectArray array = null ;
    
    /**
     * コンストラクタ.
     */
    public DataMap() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * HashMapからデータをコピーします.
     * <BR>
     * @param map 対象のHashMapを設定します.
     * @exception InputException 入力例外.
     */
    public DataMap( HashMap map )
        throws InputException {
        
        int i ;
        int len ;
        String name = null ;
        Object value = null ;
        Object[] keys = null ;
        
        if( map == null || ( len = map.size() ) <= 0 ) {
            throw new InputException( "引数は不正です" ) ;
        }
        
        keys = map.keySet().toArray() ;
        array = new ObjectArray() ;
        
        for( i = 0 ; i < len ; i ++ ) {
            
            name = ( String )keys[ i ] ;
            
            if( name != null && name.length() >= 0 ) {
                
                value = map.get( name ) ;
                name = name.trim().toLowerCase() ;
                
                if(
                    name != null && name.length() > 0
                ) {
                    this.set( name,value ) ;
                }
                
            }
        }
        
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected void finalize() throws Exception {
        try {
            this.clear() ;
        } catch( Exception t ) {
        }
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        if( array != null ) {
            array.clear() ;
        }
        
        array = null ;
    }
    
    /**
     * 情報設定.
     * <BR><BR>
     * 対象の情報を設定します.
     * <BR>
     * @param name 対象の名前を設定します.
     * @param value 対象の要素を設定します.
     */
    public void set( String name,Object value ) {
        
        int pnt ;
        DataMapChild ch = null ;
        
        if(
            name == null || ( name = name.trim().toLowerCase() ).length() <= 0 ||
            value == null
        ) {
            return ;
        }
        
        try {
            
            if( array == null ) {
                array = new ObjectArray() ;
            }
            
            pnt = this.getNumber( name ) ;
            
            if( pnt >= 0 ) {
                ch = ( DataMapChild )array.get( pnt ) ;
            }
            else {
                ch = new DataMapChild() ;
                array.add( ch ) ;
            }
            
            ch.setName( name ) ;
            ch.setValue( value ) ;
            
        } catch( Exception e ) {
        }
        
    }
    
    /**
     * 情報取得.
     * <BR><BR>
     * 対象の情報を取得します.
     * <BR>
     * @param name 対象名を設定します.
     * @return Object 対象の情報が返されます.
     */
    public Object get( String name ) {
        
        int pnt ;
        Object ret = null ;
        
        if( ( pnt = this.getNumber( name ) ) >= 0 ) {
            ret = ( ( DataMapChild )array.get( pnt ) ).getValue() ;
        }
        
        return ret ;
    }
    
    /**
     * 格納情報数を取得.
     * <BR><BR>
     * 格納されている情報数を取得します.
     * <BR>
     * @return int 格納されている情報数が返されます.
     */
    public int size() {
        
        if( array != null ) {
            return array.size() ;
        }
        
        return 0 ;
    }
    
    /**
     * 格納情報名群が返されます.
     * <BR><BR>
     * 格納されている情報名群が返されます.
     * <BR>
     * @return String[] 格納されている情報名群が返されます.
     */
    public String[] getNames() {
        
        int i ;
        int len ;
        String[] ret = null ;
        
        if( array != null && ( len = array.size() ) > 0 ) {
            
            ret = new String[ len ] ;
            for( i = 0 ; i < len ; i ++ ) {
                ret[ i ] = ( ( DataMapChild )array.get( i ) ).getName() ;
            }
            
        }
        
        return ret ;
        
    }
    
    /**
     * 対象名が存在するかチェック.
     * <BR><BR>
     * 対象名が存在するかチェックします.
     * <BR>
     * @param name 対象名を設定します.
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、存在します.<BR>
     *                 [false]が返された場合、存在しません.
     */
    public boolean isData( String name ) {
        return ( this.getNumber( name ) >= 0 ) ? true : false ;
    }
    
    
    
    /**
     * 指定名に対する要素項番を取得.
     */
    private final int getNumber( String name ) {
        
        int i ;
        int len ;
        int ret = -1 ;
        DataMapChild ch = null ;
        
        if(
            name == null || ( name = name.trim().toLowerCase() ).length() <= 0 ||
            array == null || ( len = array.size() ) <= 0
        ) {
            return -1 ;
        }
        
        for( i = 0 ; i < len ; i ++ ) {
            ch = ( DataMapChild )array.get( i ) ;
            if( ch != null && name.equals( ch.getName() ) == true ) {
                ret = i ;
                break ;
            }
        }
        
        return ret ;
        
    }
    
}

/**
 * データ格納オブジェクト.
 */
class DataMapChild implements Serializable
{
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            DataMapChild.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * パラメータ名.
     */
    private String name = null ;
    
    /**
     * パラメータ内容.
     */
    private Object value = null ;
    
    /**
     * コンストラクタ.
     */
    protected DataMapChild() {
        
    }
    
    /**
     * name を取得.
     * <BR><BR>
     * @return name が返されます.
     */
    public String getName() {
        return name;
    }
    
    /**
     * name を設定.
     * <BR><BR>
     * @param name 対象条件 name に設定.
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * value を取得.
     * <BR><BR>
     * @return value が返されます.
     */
    public Object getValue() {
        return value;
    }
    
    /**
     * value を設定.
     * <BR><BR>
     * @param value 対象条件 value に設定.
     */
    public void setValue(Object value) {
        this.value = value;
    }
    
}

