/*
 * @(#)MaachangConnectCustom.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.connect ;

import java.net.InetAddress;

import org.maachang.connect.table.CompletionTable;
import org.maachang.connect.table.ConnectTable;
import org.maachang.connect.table.MaachangConnectTableFactory;
import org.maachang.connect.table.SendReceiveTable;
import org.maachang.connect.table.SendTable;
import org.maachang.connect.table.UnderReceiveTable;
import org.maachang.connect.thread.MaachangConnectThreadFactory;

import org.maachang.commons.exception.AccessException;
import org.maachang.commons.exception.InputException;
import org.maachang.commons.net.BaseUdpProtocol;
import org.maachang.commons.net.UdpProtocol;


/**
 * UDPプロトコルに再送機能を持たせた詳細定義可能なプロトコル(MaachangConnect).
 * <BR><BR>
 * このプロトコルは、UDPの特性を持ちつつ、TCP/IPのような
 * 再送機能を持ちます.
 * <BR>
 * MaachangConnectを利用する想定としては、１対複数との関係で接続する場合に
 * 利用することです.
 *
 * @version 2006/12/22
 * @author  Masahito Suzuki
 * @since   MaachangConnect 1.00
 */
public class MaachangConnectCustom extends AbstractMaachangConnect implements MaachangConnectInterface {
    
    /**
     * コンストラクタ.
     */
    public MaachangConnectCustom() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * MaachangConnectプロトコルをオープンします.
     * <BR>
     * @param bean カスタムBeanを設定します.
     * @exception InputException 入力例外.
     * @exception AccessException アクセス例外.
     */
    public MaachangConnectCustom( MaachangConnectCustomBean bean )
        throws InputException,AccessException {
        this.open( bean ) ;
    }
    
    /**
     * オープン処理.
     * <BR><BR>
     * MaachangConnectプロトコルをオープンします.
     * <BR>
     * @param bean カスタムBeanを設定します.
     * @exception InputException 入力例外.
     * @exception AccessException アクセス例外.
     */
    public void open( MaachangConnectCustomBean bean )
        throws InputException,AccessException {
        
        if( bean == null ) {
            throw new InputException( "引数は不正です" ) ;
        }
        
        sync.create() ;
        
        int buffer = bean.getBuffer() ;
        if( buffer == -1 ) {
            buffer = DEFAULT_BUFFER ;
        }
        else if( buffer <= MIN_BUFFER ) {
            buffer = MIN_BUFFER ;
        }
        else if( buffer >= MAX_BUFFER ) {
            buffer = MAX_BUFFER ;
        }
        
        try {
            
            int port = bean.getPort() ;
            InetAddress bindAddress = bean.getBindAddress() ;
            BaseUdpProtocol udp = new UdpProtocol() ;
            
            if( port == -1 ) {
                udp.open( buffer ) ;
            }
            else if( bindAddress != null ) {
                udp.open( buffer,port,bindAddress ) ;
            }
            else {
                udp.open( buffer,port ) ;
            }
            
            SendReceiveTable sendReceiveTable = new SendReceiveTable(
                bean.getRollSize() ) ;
            
            ConnectTable connectTable = new ConnectTable(
                bean.getConnectStartTableTimeout(),bean.getConnectStartTablePingTiming() ) ;
            
            SendTable sendTable = new SendTable( bean.getSendTableTimeout() ) ;
            
            UnderReceiveTable underReceiveTable = new UnderReceiveTable(
                bean.getUnderReceiveTimeout(),bean.getResourceType(),
                bean.getUnderReceiveRetryTiming(),bean.getUnderReceiveMaxRetryCount() ) ;
            
            CompletionTable completionTable = new CompletionTable() ;
            
            boolean cb32 = false ;
            String[] words = null ;
            if( bean.getCb32() != null ) {
                cb32 = bean.getCb32().isCb32() ;
                words = bean.getCb32().getWords() ;
            }
            
            MaachangConnectTableFactory tableFactory = new MaachangConnectTableFactory(
                cb32,words,
                sendReceiveTable,connectTable,sendTable,
                underReceiveTable,completionTable ) ;
            
            MaachangConnectThreadFactory factory = new MaachangConnectThreadFactory(
                udp,tableFactory,
                bean.getExecutionAnalysisLength(),bean.getExecutionUnderRetryLength(),
                bean.getExecutionSendLength(),bean.getExecutionReceiveLength() ) ;
            
            synchronized( sync.get() ) {
                this.factory = factory ;
            }
            
        } catch( AccessException ae ) {
            throw ae ;
        } catch( Exception e ) {
            throw new AccessException( e ) ;
        }
        
    }
    
}

