/*
 * @(#)MaachangConnectCustomBean.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.connect ;

import java.io.Serializable;
import java.net.InetAddress;

import org.maachang.commons.resource.ResourceType;
import org.maachang.commons.serialize.SerializeUtil;

/**
 * カスタムMaachangConnectプロトコルBean.
 *
 * @version 2006/12/23
 * @author  Masahito Suzuki
 * @since   MaachangConnect 1.00
 */
public class MaachangConnectCustomBean implements Serializable {
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            MaachangConnectCustomBean.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    
    
    /**
     * バインドポート番号.
     */
    private int port = -1 ;
    
    /**
     * バインドアドレス.
     */
    private InetAddress bindAddress = null ;
    
    /**
     * 送受信バッファ長.
     */
    private int buffer = -1 ;
    
    /**
     * リソースタイプ.
     */
    private ResourceType resourceType = null ;
    
    /**
     * 電文送受信ロールサイズ.
     */
    private int rollSize = -1 ;
    
    /**
     * コネクション開始管理タイムアウト値.
     */
    private long connectStartTableTimeout = -1L ;
    
    /**
     * コネクション開始管理Ping送信タイミング.
     */
    private long connectStartTablePingTiming = -1L ;
    
    /**
     * パケット送信管理タイムアウト値.
     */
    private long sendTableTimeout = -1L ;
    
    /**
     * 受信待ち電文タイムアウト値.
     */
    private long underReceiveTimeout = -1L ;
    
    /**
     * 受信待ち電文再送タイミング.
     */
    private long underReceiveRetryTiming = -1L ;
    
    /**
     * 受信待ち電文再送最大回数.
     */
    private int underReceiveMaxRetryCount = -1 ;
    
    /**
     * 電文解析スレッドサイズ.
     */
    private int executionAnalysisLength = -1 ;
    
    /**
     * パケット受信待ちスレッドサイズ.
     */
    private int executionUnderRetryLength = -1 ;
    
    /**
     * 電文送信スレッドサイズ.
     */
    private int executionSendLength = -1 ;
    
    /**
     * 電文受信スレッドサイズ.
     */
    private int executionReceiveLength = -1 ;
    
    /**
     * 暗号情報.
     */
    private Cb32Bean cb32 = null ;
    
    
    
    /**
     * バインドアドレスを取得.
     * <BR><BR>
     * @return バインドアドレスが返されます.
     */
    public InetAddress getBindAddress() {
        return bindAddress;
    }

    /**
     * バインドアドレスを設定.
     * <BR><BR>
     * @param bindAddress バインドアドレスを設定します.
     */
    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    /**
     * 送受信バッファを取得.
     * <BR><BR>
     * @return 送受信バッファが返されます.
     */
    public int getBuffer() {
        return buffer;
    }

    /**
     * 送受信バッファを設定.
     * <BR><BR>
     * @param buffer 送受信バッファを設定します.
     */
    public void setBuffer(int buffer) {
        this.buffer = buffer;
    }

    /**
     * バインドポートを取得.
     * <BR><BR>
     * @return バインドポートが返されます.
     */
    public int getPort() {
        return port;
    }

    /**
     * バインドポートを設定.
     * <BR><BR>
     * @param port バインドポートを設定します.
     */
    public void setPort(int port) {
        this.port = port;
    }

    /**
     * 電文送受信ロールサイズを取得.
     * <BR><BR>
     * @return 電文送受信ロールサイズが返されます.
     */
    public int getRollSize() {
        return rollSize;
    }

    /**
     * 電文送受信ロールサイズを設定.
     * <BR><BR>
     * @param rollSize 電文送受信ロールサイズを設定します.
     */
    public void setRollSize(int rollSize) {
        this.rollSize = rollSize;
    }

    /**
     * コネクション開始管理Ping送信タイミングを取得.
     * <BR><BR>
     * @return コネクション開始管理Ping送信タイミングが返されます.
     */
    public long getConnectStartTablePingTiming() {
        return connectStartTablePingTiming;
    }

    /**
     * コネクション開始管理Ping送信タイミングを設定.
     * <BR><BR>
     * @param connectStartTablePingTiming コネクション開始管理Ping送信タイミングを設定します.
     */
    public void setConnectStartTablePingTiming(long connectStartTablePingTiming) {
        this.connectStartTablePingTiming = connectStartTablePingTiming;
    }

    /**
     * コネクション開始管理タイムアウト値を取得.
     * <BR><BR>
     * @return コネクション開始管理タイムアウト値が返されます.
     */
    public long getConnectStartTableTimeout() {
        return connectStartTableTimeout;
    }

    /**
     * コネクション開始管理タイムアウト値を設定.
     * <BR><BR>
     * @param connectStartTableTimeout コネクション開始管理タイムアウト値を設定します.
     */
    public void setConnectStartTableTimeout(long connectStartTableTimeout) {
        this.connectStartTableTimeout = connectStartTableTimeout;
    }

    /**
     * 電文解析スレッドサイズを取得.
     * <BR><BR>
     * @return 電文解析スレッドサイズが返されます.
     */
    public int getExecutionAnalysisLength() {
        return executionAnalysisLength;
    }

    /**
     * 電文解析スレッドサイズを設定.
     * <BR><BR>
     * @param executionAnalysisLength 電文解析スレッドサイズを設定します.
     */
    public void setExecutionAnalysisLength(int executionAnalysisLength) {
        this.executionAnalysisLength = executionAnalysisLength;
    }

    /**
     * 電文受信スレッドサイズを取得.
     * <BR><BR>
     * @return 電文受信スレッドサイズが返されます.
     */
    public int getExecutionReceiveLength() {
        return executionReceiveLength;
    }

    /**
     * 電文受信スレッドサイズを設定.
     * <BR><BR>
     * @param executionReceiveLength 電文受信スレッドサイズを設定します.
     */
    public void setExecutionReceiveLength(int executionReceiveLength) {
        this.executionReceiveLength = executionReceiveLength;
    }

    /**
     * 電文送信スレッドサイズを取得.
     * <BR><BR>
     * @return 電文送信スレッドサイズが返されます.
     */
    public int getExecutionSendLength() {
        return executionSendLength;
    }

    /**
     * 電文送信スレッドサイズを設定.
     * <BR><BR>
     * @param executionSendLength 電文送信スレッドサイズを設定します.
     */
    public void setExecutionSendLength(int executionSendLength) {
        this.executionSendLength = executionSendLength;
    }

    /**
     * パケット受信待ちスレッドサイズを取得.
     * <BR><BR>
     * @return パケット受信待ちスレッドサイズが返されます.
     */
    public int getExecutionUnderRetryLength() {
        return executionUnderRetryLength;
    }

    /**
     * パケット受信待ちスレッドサイズを設定.
     * <BR><BR>
     * @param executionUnderRetryLength パケット受信待ちスレッドサイズを設定します.
     */
    public void setExecutionUnderRetryLength(int executionUnderRetryLength) {
        this.executionUnderRetryLength = executionUnderRetryLength;
    }

    /**
     * リソースタイプを取得.
     * <BR><BR>
     * @return リソースタイプが返されます.
     */
    public ResourceType getResourceType() {
        return resourceType;
    }

    /**
     * リソースタイプを設定.
     * <BR><BR>
     * @param resourceType リソースタイプを設定します.
     */
    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * パケット送信管理タイムアウト値を取得.
     * <BR><BR>
     * @return パケット送信管理タイムアウト値が返されます.
     */
    public long getSendTableTimeout() {
        return sendTableTimeout;
    }

    /**
     * パケット送信管理タイムアウト値を設定.
     * <BR><BR>
     * @param sendTableTimeout パケット送信管理タイムアウト値を設定します.
     */
    public void setSendTableTimeout(long sendTableTimeout) {
        this.sendTableTimeout = sendTableTimeout;
    }

    /**
     * 受信待ち電文再送最大回数を取得.
     * <BR><BR>
     * @return 受信待ち電文再送最大回数が返されます.
     */
    public int getUnderReceiveMaxRetryCount() {
        return underReceiveMaxRetryCount;
    }

    /**
     * 受信待ち電文再送最大回数を設定.
     * <BR><BR>
     * @param underReceiveMaxRetryCount 受信待ち電文再送最大回数を設定します.
     */
    public void setUnderReceiveMaxRetryCount(int underReceiveMaxRetryCount) {
        this.underReceiveMaxRetryCount = underReceiveMaxRetryCount;
    }

    /**
     * 受信待ち電文再送タイミングを取得.
     * <BR><BR>
     * @return 受信待ち電文再送タイミングが返されます.
     */
    public long getUnderReceiveRetryTiming() {
        return underReceiveRetryTiming;
    }

    /**
     * 受信待ち電文再送タイミングを設定.
     * <BR><BR>
     * @param underReceiveRetryTiming 受信待ち電文再送タイミングを設定します.
     */
    public void setUnderReceiveRetryTiming(long underReceiveRetryTiming) {
        this.underReceiveRetryTiming = underReceiveRetryTiming;
    }

    /**
     * 受信待ち電文タイムアウト値を取得.
     * <BR><BR>
     * @return 受信待ち電文タイムアウト値が返されます.
     */
    public long getUnderReceiveTimeout() {
        return underReceiveTimeout;
    }

    /**
     * 受信待ち電文タイムアウト値を設定.
     * <BR><BR>
     * @param underReceiveTimeout 受信待ち電文タイムアウト値を設定します.
     */
    public void setUnderReceiveTimeout(long underReceiveTimeout) {
        this.underReceiveTimeout = underReceiveTimeout;
    }

    /**
     * 暗号情報 を取得.
     * <BR><BR>
     * @return 暗号情報 が返されます.
     */
    public Cb32Bean getCb32() {
        return cb32;
    }

    /**
     * 暗号情報 を設定.
     * <BR><BR>
     * @param cb32 暗号情報 を設定します.
     */
    public void setCb32(Cb32Bean cb32) {
        this.cb32 = cb32;
    }
    
}

