/*
 * @(#)MqUtil.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main ;

import org.maachang.commons.util.UtilCom;
import org.maachang.queue.config.MqDefine;

/**
 * MQユーティリティ.
 *  
 * @version 2006/09/02
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class MqUtil
{
    
    
    /**
     * コンストラクタ.
     */
    private MqUtil() {
        
    }
    
    /**
     * 対象名の内容を置き換える.
     * <BR><BR>
     * 対象名の内容を置き換えます.
     * <BR>
     * @param string 変換元の名前を設定します.
     * @param replace 置き換え元の名前を設定します.
     * @param dest 置き換え先の名前を設定します.
     * @return String 置き換えられた内容が返されます.<BR>
     *                [null]が返された場合、置き換え処理に失敗しました.
     */
    public static final String replaceString( String string,String replace,String dest ) {
        
        String ret = null ;
        
        if(
            string == null || string.length() <= 0 ||
            string.indexOf( MqDefine.REPACE_START_OF_END ) == -1 ||
            replace == null || replace.length() <= 0 ||
            dest == null || dest.length() <= 0
        ) {
            return null ;
        }
        
        replace = new StringBuffer().
            append( MqDefine.REPACE_START_OF_END ).
            append( replace ).
            append( MqDefine.REPACE_START_OF_END ).
            toString() ;
        
        try {
            ret = UtilCom.changeString( string,replace,dest ) ;
        } catch( Exception e ) {
            ret = null ;
        }
        
        return ret ;
        
    }
    
}

