/*
 * @(#)LastReceiveIdManage.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel ;

import org.maachang.commons.util.array.ObjectArray;

/**
 * 最終受信D管理.
 * <BR><BR>
 * 最終受信IDを管理するオブジェクト.
 *  
 * @version 2006/01/29
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class LastReceiveIdManage {
    
    /**
     * 完全削除タイミング.
     * 15分.
     */
    private static final long DESTROY_TIMING = 900000L ;
    
    /**
     * 論理削除タイミング.
     * 7.5分.
     */
    private static final long DELETE_TIMING = 450000L ;
    
    /**
     * クリアタイミング.
     * 2.5分.
     */
    private static final long CLEAR_TIMING = 150000L ;
    
    /**
     * 情報管理テーブル.
     */
    private final ObjectArray array = new ObjectArray() ;
    
    
    /**
     * コンストラクタ.
     */
    public LastReceiveIdManage() {
        
    }
    
    /**
     * すべての情報を破棄.
     */
    public synchronized void destroy() {
        this.array.clear() ;
    }
    
    /**
     * 受信IDが正しいかチェック.
     * <BR><BR>
     * 受信IDが正しいかチェックします.
     * <BR>
     * @param manager 対象のキューマネージャ名を設定します.
     * @param queue 対象のキュー名を設定します.
     * @param macAddress 対象のマックアドレスを設定します.
     * @param id 対象の受信IDを設定します.
     * @return boolean チェック結果が返されます.<BR>
     *                 [null]以外の場合、受信IDの電文は、
     *                 キューに設定可能です.
     */
    public synchronized LastReceiveIdChild getReceiveIdChild(
        String manager,String queue,long macAddress,long id ) {
        
        LastReceiveIdChild ch = this.getSearch( manager,queue,macAddress ) ;
        
        if( ch != null ) {
            if( ch.isReceive( id ) == true ) {
                return ch ;
            }
            else {
                return null ;
            }
        }
        
        ch = this.getCleanObject() ;
        ch.create( manager,queue,macAddress ) ;
        ch.firstSendId( id ) ;
        
        return ch ;
        
    }
    
    
    
    /**
     * 検索処理.
     */
    private final LastReceiveIdChild getSearch(
        String manager,String queue,long macAddress ) {
        
        int len = array.size() ;
        long time = System.currentTimeMillis() ;
        
        LastReceiveIdChild ret = null ;
        
        for( int i = 0 ; i < len ; i ++ ) {
            LastReceiveIdChild ch = ( LastReceiveIdChild )array.get( i ) ;
            if( ch != null ) {
                if( ret == null && manager.equals( ch.getQueueManager() ) == true &&
                    queue.equals( ch.getQueue() ) == true &&
                    macAddress == ch.getMacAddress() ) {
                    ret = ch ;
                }
                else if( time >= ch.getUpdateTime() + CLEAR_TIMING ) {
                    ch.clear() ;
                }
            }
        }
        
        return ret ;
    }
    
    /**
     * 空の条件を取得.
     */
    private final LastReceiveIdChild getCleanObject() {
        
        int len = array.size() ;
        long time = System.currentTimeMillis() ;
        
        int i ;
        LastReceiveIdChild ch = null ;
        LastReceiveIdChild ret = null ;
        
        for( i = len-1 ; i >= 0 ; i -- ) {
            ch = ( LastReceiveIdChild )array.get( i ) ;
            if( ch != null ) {
                if( time >= ch.getUpdateTime() + DESTROY_TIMING ) {
                    array.remove( i ) ;
                }
                else if( time >= ch.getUpdateTime() + DELETE_TIMING ) {
                    ch.destroy() ;
                    ret = ch ;
                }
            }
        }
        
        if( ret == null ) {
            ret = new LastReceiveIdChild() ;
            array.add( ret ) ;
        }
        
        return ret ;
    }
    
}

