/*
 * @(#)ChannelServiceUtil.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel.service ;

import java.net.InetAddress;

import org.maachang.commons.resource.BinResource;
import org.maachang.queue.main.channel.protocol.ChannelProtocol;
import org.maachang.queue.main.channel.protocol.ProtocolObject;
import org.maachang.queue.main.channel.protocol.ProtocolResultError;
import org.maachang.queue.main.channel.protocol.ProtocolResultSuccess;
import org.maachang.queue.main.connect.Connect;
import org.maachang.queue.main.connect.ConnectFactory;

/**
 * チャネルサービスユーティリティ.
 *  
 * @version 2006/12/23
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class ChannelServiceUtil {
    
    private ChannelServiceUtil() {}
    
    /**
     * 正常電文を送信.
     * <BR><BR>
     * 指定条件の正常電文を送信します.
     * <BR>
     * @param cb32Word 暗号ワードを設定します.
     * @param address 送信先アドレスを設定します.
     * @param port 送信先ポート番号を設定します.
     * @param protocol 対象のプロトコルオブジェクトを設定します.
     * @param connectName 対象のコネクション名を設定します.
     * @param result エラー電文を設定します.
     * @param error 対象エラーコードを設定します.
     */
    public static final void sendReturnSuccess( String cb32Word,
        InetAddress address,int port,
        String connectName,ProtocolObject protocol,
        ProtocolResultSuccess result ) {
        
        ChannelServiceUtil.sendReturnSuccess(
            cb32Word,null,address,port,connectName,protocol,result ) ;
    }
    
    /**
     * 正常電文を送信.
     * <BR><BR>
     * 指定条件の正常電文を送信します.
     * <BR>
     * @param cb32Word 暗号ワードを設定します.
     * @param srcManagerName 対象の送信元キューマネージャ名を設定します.
     * @param address 送信先アドレスを設定します.
     * @param port 送信先ポート番号を設定します.
     * @param protocol 対象のプロトコルオブジェクトを設定します.
     * @param connectName 対象のコネクション名を設定します.
     * @param result エラー電文を設定します.
     * @param error 対象エラーコードを設定します.
     */
    public static final void sendReturnSuccess( String cb32Word,
        String srcManagerName,InetAddress address,int port,
        String connectName,ProtocolObject protocol,
        ProtocolResultSuccess result ) {
        
        Connect connect = ConnectFactory.get( connectName ) ;
        if( connect == null ) {
            return ;
        }
        
        result.setReturnType( protocol.getType() ) ;
        result.setId( protocol.getId() ) ;
        result.setName( protocol.getName() ) ;
        if( srcManagerName != null ) {
            result.setQueueManagerName( srcManagerName ) ;
        }
        else {
            result.setQueueManagerName( protocol.getQueueManagerName() ) ;
        }
        result.setChannelName( protocol.getChannelName() ) ;
        result.setChannelId( protocol.getChannelId() ) ;
        result.setReceivePort( connect.getPort() ) ;
        
        // 正常電文を生成.
        BinResource send = ChannelProtocol.getProtocolResultSuccessByTelegram( result ) ;
        
        // 処理結果電文を送信.
        connect.sendByResource( cb32Word,address,port,send ) ;
        
    }
    
    /**
     * エラー電文を送信.
     * <BR><BR>
     * 指定条件のエラー電文を送信します.
     * <BR>
     * @param cb32Word 暗号ワードを設定します.
     * @param address 送信先アドレスを設定します.
     * @param port 送信先ポート番号を設定します.
     * @param connectName 対象のコネクション名を設定します.
     * @param protocol 対象のプロトコルオブジェクトを設定します.
     * @param result エラー電文を設定します.
     * @param error 対象エラーコードを設定します.
     */
    public static final void sendReturnError( String cb32Word,
        InetAddress address,int port,
        String connectName,ProtocolObject protocol,
        ProtocolResultError result,int error ) {
        
        ChannelServiceUtil.sendReturnError(
            cb32Word,null,address,port,connectName,protocol,
            result,error ) ;
    }
    
    /**
     * エラー電文を送信.
     * <BR><BR>
     * 指定条件のエラー電文を送信します.
     * <BR>
     * @param cb32Word 暗号ワードを設定します.
     * @param srcManagerName 対象の送信元キューマネージャ名を設定します.
     * @param address 送信先アドレスを設定します.
     * @param port 送信先ポート番号を設定します.
     * @param connectName 対象のコネクション名を設定します.
     * @param protocol 対象のプロトコルオブジェクトを設定します.
     * @param result エラー電文を設定します.
     * @param error 対象エラーコードを設定します.
     */
    public static final void sendReturnError( String cb32Word,
        String srcManagerName,InetAddress address,int port,
        String connectName,ProtocolObject protocol,
        ProtocolResultError result,int error ) {
        
        Connect connect = ConnectFactory.get( connectName ) ;
        if( connect == null ) {
            return ;
        }
        
        result.setReturnType( protocol.getType() ) ;
        result.setId( protocol.getId() ) ;
        result.setName( protocol.getName() ) ;
        if( srcManagerName != null ) {
            result.setQueueManagerName( srcManagerName ) ;
        }
        else {
            result.setQueueManagerName( protocol.getQueueManagerName() ) ;
        }
        result.setChannelName( protocol.getChannelName() ) ;
        result.setChannelId( protocol.getChannelId() ) ;
        result.setReceivePort( connect.getPort() ) ;
        
        // エラーコードを設定.
        result.setErrorCode( error ) ;
        
        // エラー電文を生成.
        BinResource send = ChannelProtocol.getProtocolResultErrorByTelegram( result ) ;
        
        // 処理結果電文を送信.
        connect.sendByResource( cb32Word,address,port,send ) ;
        
    }
    
}

