/*
 * @(#)CoreReceiveChild.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.channel.service.receive.core ;

import java.net.InetAddress;

import org.maachang.commons.resource.BinResource;

/**
 * コア受信テーブルチャイルド.
 *
 * @version 2006/12/21
 * @author  Masahito Suzuki
 * @since   MaachangQ 1.00
 */
public class CoreReceiveChild {
    
    /**
     * バイナリデータ.
     */
    private BinResource binResource = null ;
    
    /**
     * コネクションアドレス.
     */
    private InetAddress address = null ;
    
    /**
     * コネクションポート番号.
     */
    private int port = -1 ;
    
    /**
     * 受信コネクション名.
     */
    private String connectName = null ;
    
    /**
     * 暗号ワード.
     */
    private String cb32Word = null ;
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param connectName 受信コネクション名を設定します.
     * @param binResource 対象のバイナリデータを設定します.
     * @param InetAddress 対象のコネクションアドレスを設定します.
     * @param port 対象のコネクションポート番号を設定します.
     * @param cb32Word 対象の暗号ワードが設定されます.
     */
    public CoreReceiveChild(
        String connectName,BinResource binResource,InetAddress address,
        int port,String cb32Word ) {
        this.connectName = connectName ;
        this.binResource = binResource ;
        this.address = address ;
        this.port = port ;
        this.cb32Word = cb32Word ;
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() {
        connectName = null ;
        binResource = null ;
        address = null ;
        port = -1 ;
        cb32Word = null ;
    }

    /**
     * binResourceを取得.
     * <BR><BR>
     * @return binResource が返されます。
     */
    public BinResource getBinResource() {
        return binResource;
    }

    /**
     * binResourceを設定.
     * <BR><BR>
     * @param binResource 対象のbinResourceを設定.
     */
    public void setBinResource(BinResource binResource) {
        this.binResource = binResource;
    }

    /**
     * connectNameを取得.
     * <BR><BR>
     * @return connectName が返されます。
     */
    public String getConnectName() {
        return connectName;
    }

    /**
     * connectNameを設定.
     * <BR><BR>
     * @param connectName 対象のconnectNameを設定.
     */
    public void setConnectName(String connectName) {
        this.connectName = connectName;
    }

    /**
     * addressを取得.
     * <BR><BR>
     * @return address が返されます。
     */
    public InetAddress getAddress() {
        return address;
    }

    /**
     * portを取得.
     * <BR><BR>
     * @return port が返されます。
     */
    public int getPort() {
        return port;
    }

    /**
     * cb32Wordを取得.
     * <BR><BR>
     * @return cb32Word が返されます。
     */
    public String getCb32Word() {
        return cb32Word;
    }

    /**
     * cb32Wordを設定.
     * <BR><BR>
     * @param cb32Word 対象のcb32Wordを設定.
     */
    public void setCb32Word(String cb32Word) {
        this.cb32Word = cb32Word;
    }

}
