/*
 * @(#)QueueValue.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.queue.base ;

import java.io.Serializable;

import org.maachang.commons.serialize.SerializeUtil;
import org.maachang.queue.main.queue.QueueKey;


/**
 * キューKey情報.
 * <BR><BR>
 * キューKey情報を表すオブジェクト.
 *  
 * @version 2006/08/29
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class BaseQueueKey extends QueueKey implements Serializable {
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            BaseQueueKey.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * 管理元キューマネージャ名.
     */
    private String parentManagerName = null ;
    
    /**
     * コンストラクタ.
     */
    protected BaseQueueKey() {
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param queueType キュータイプを設定します.
     * @param parentManagerName 管理元キューマネージャ名を設定します.
     * @param name キュー名を設定します.
     */
    public BaseQueueKey( int queueType,String parentManagerName,String name ) {
        super( queueType,name ) ;
        this.parentManagerName = parentManagerName ;
    }
    
    /**
     * 管理元キューマネージャ名を設定.
     * <BR><BR>
     * @param parentManagerName 管理元キューマネージャ名を設定します.
     */
    public void setParentManagerName( String parentManagerName ) {
        this.parentManagerName = parentManagerName ;
    }
    
    /**
     * 管理元キューマネージャ名を取得.
     * <BR><BR>
     * @return String 管理元キューマネージャ名が返されます.
     */
    public String getParentManagerName() {
        return this.parentManagerName;
    }
    
}

