/*
 * @(#)SaveAndLoadService.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.main.service ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.commons.sys.NamingManager;
import org.maachang.commons.util.UtilCom;

/**
 * セーブサービス.
 *  
 * @version 2006/12/31
 * @author  masahito suzuki
 * @since   MaachangQ 1.00
 */
public class SaveAndLoadService {
    
    /**
     * セーブタイプ : キューマネージャ.
     */
    public static final int SAVE_TYPE_MANAGER = SaveAndLoad.SAVE_TYPE_MANAGER ;
    
    /**
     * セーブタイプ : キュー.
     */
    public static final int SAVE_TYPE_QUEUE = SaveAndLoad.SAVE_TYPE_QUEUE ;
    
    /**
     * セーブタイプ : チャネル.
     */
    public static final int SAVE_TYPE_CHANNEL = SaveAndLoad.SAVE_TYPE_CHANNEL ;
    
    /**
     * セーブタイプ : コネクション.
     */
    public static final int SAVE_TYPE_CONNECT = SaveAndLoad.SAVE_TYPE_CONNECT ;
    
    /**
     * セーブタイプ : キャッシュ.
     */
    public static final int SAVE_TYPE_CACHE = SaveAndLoad.SAVE_TYPE_CACHE ;
    
    /**
     * ログオブジェクト.
     */
    private static final Log LOG = LogFactory.getLog( SaveAndLoadService.class ) ;
    
    /**
     * ネーミングマネージャ登録名.
     */
    public static final String NAMING_MANAGER = "SAVE@maachangq.main.service" ;
    
    /**
     * 開始待機時間.
     */
    private static final int WAIT_TIME = 1500 ;
    
    /**
     * 同期オブジェクト.
     */
    private static final Object SYNC = new Object() ;
    
    /**
     * コンストラクタ.
     */
    public SaveAndLoadService() { }
    
    
    /**
     * 初期化処理.
     * <BR><BR>
     * 初期化処理を行います.
     */
    public void init() {
        //this.init( ConfigService.getMqConfig().getAutoSaveTiming() ) ;
        this.init( -1L ) ;
    }
    
    /**
     * 初期化処理.
     * <BR><BR>
     * 初期化処理を行います.
     * <BR>
     * @param time データセーブ間隔値を設定します.<BR>
     *             設定可能な最小値は[60000]ミリ秒です.<BR>
     *             設定可能な最大値は[1800000]ミリ秒です.
     */
    public void init( long time ) {
        
        LOG.info( "#### MaachangQセーブサービス生成処理 ####" ) ;
        LOG.info( "# オートデータセーブ間隔:" + time ) ;
        
        // 現在の条件を破棄.
        this.destroy( false ) ;
        
        // 前回の構成情報を読み込む.
        SaveAndLoad.load( true ) ;
        
        // しばらく待機.
        UtilCom.sleep( WAIT_TIME ) ;
        
        if( time > 0L ) {
            // オートセーブスレッド開始.
            SaveThread thread = new SaveThread( time ) ;
            
            // ネーミングマネージャに登録.
            synchronized( SYNC ) {
                
                NamingManager.add( NAMING_MANAGER,thread ) ;
                
            }
            
        }
        
    }
    
    /**
     * 終了化処理.
     * <BR><BR>
     * 終了化処理を行います.
     */
    public void destroy() {
        this.destroy( true ) ;
    }
    
    /**
     * 終了化処理.
     * <BR><BR>
     * 終了化処理を行います.
     * <BR>
     * @param mode ログ表示モードを設定します.
     */
    public void destroy( boolean mode ) {
        
        if( mode == true ) {
            LOG.info( "#### MaachangQセーブサービス破棄処理 ####" ) ;
        }
        
        // ネーミングマネージャを破棄.
        synchronized( SYNC ) {
            
            NamingManager.remove( NAMING_MANAGER ) ;
            
        }
        
    }
    
    /**
     * 構成情報を全て破棄.
     * <BR><BR>
     * 現在の構成情報を全て破棄します.
     */
    public static final void delete() {
        synchronized( SYNC ) {
            SaveAndLoad.destroy() ;
        }
    }
    
    /**
     * 構成情報を保存.
     * <BR><BR>
     * 現在の構成情報を保存します.
     */
    public static final void save() {
        synchronized( SYNC ) {
            SaveAndLoad.save() ;
        }
    }
    
    /**
     * 構成情報を保存.
     * <BR><BR>
     * 現在の構成情報を保存します.
     * <BR>
     * @param type セーブタイプを設定します.
     */
    public static final void save( int type ) {
        synchronized( SYNC ) {
            SaveAndLoad.save( type,null ) ;
        }
    }
    
    /**
     * 構成情報の読み込み.
     * <BR><BR>
     * 現在の構成情報を読み込みます.
     * <BR>
     * @param mode 読み込み時のモード設定.<BR>
     *              [true]を設定した場合、読み込む前の現在の全ての構成をクリアします.
     *              [false]を設定した場合、構成情報が既に存在する場合、処理しません.
     */
    public static final void load( boolean mode ) {
        synchronized( SYNC ) {
            SaveAndLoad.load( mode ) ;
        }
    }
}

