/*
 * @(#)AdminConnectImple.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.admin ;

import org.maachang.queue.access.MaachangQException;
import org.maachang.queue.access.admin.info.ConnectInfo;
import org.maachang.queue.access.admin.info.CreateConnectInfo;


/**
 * コネクション管理情報.
 * <BR><BR>
 * コネクション管理情報を表すオブジェクト.
 *  
 * @version 2007/01/02
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
class AdminConnectImple implements AdminConnect {
    
    /**
     * コネクションオブジェクト.
     */
    private MaachangQConnectAdminImple connect = null ;
    
    /**
     * コンストラクタ.
     */
    private AdminConnectImple() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param connect 対象オブジェクトを設定します.
     */
    protected AdminConnectImple( MaachangQConnectAdminImple connect ) {
        this.connect = connect ;
    }
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * オブジェクトを破棄します.
     * <BR>
     * @exception Exception 例外.
     */
    protected void finalize() throws Exception {
        this.connect = null ;
    }
    
    /**
     * コネクション情報を追加.
     * <BR><BR>
     * 新しいコネクション情報を生成します.<BR>
     * このメソッドは、管理者権限を持たない場合、処理できません.
     * <BR>
     * @param info コネクション情報生成条件を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void addConnect( CreateConnectInfo info )
        throws MaachangQException {
        if( connect == null || connect.isOpen() == false ) {
            return ;
        }
        
        ExecutionConnect.addConnect(
            connect.getConnect(),
            connect.getUserId(),
            connect.isRootOwner(),
            info ) ;
    }
    
    /**
     * コネクション情報を再設定.
     * <BR><BR>
     * 新しいコネクション情報を再設定します.<BR>
     * このメソッドは、管理者権限を持たない場合、処理できません.
     * <BR>
     * @param info コネクション情報生成条件を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void setConnect( ConnectInfo info )
        throws MaachangQException {
        if( connect == null || connect.isOpen() == false ) {
            return ;
        }
        
        ExecutionConnect.setConnect(
            connect.getConnect(),
            connect.getUserId(),
            connect.isRootOwner(),
            info ) ;
    }
    
    /**
     * コネクションを削除.
     * <BR><BR>
     * コネクションを削除します.<BR>
     * このメソッドは、管理者権限を持たない場合、処理できません.
     * <BR>
     * @param name 削除対象のコネクション名を設定します.
     * @exception MaachangQException MaachangQ例外.
     */
    public void removeConnect( String name )
        throws MaachangQException {
        if( connect == null || connect.isOpen() == false ) {
            return ;
        }
        
        ExecutionConnect.removeConnect(
            connect.getConnect(),
            connect.getUserId(),
            connect.isRootOwner(),
            name ) ;
    }
    
    /**
     * コネクション情報を取得.
     * <BR><BR>
     * コネクション情報を取得します.
     * <BR>
     * @param name 対象のコネクション名を設定します.
     * @return ConnectInfo 対象のコネクション情報が返されます.
     * @exception MaachangQException MaachangQ例外.
     */
    public ConnectInfo getConnect( String name )
        throws MaachangQException {
        if( connect == null || connect.isOpen() == false ) {
            return null ;
        }
        
        return ExecutionConnect.getConnect(
            connect.getConnect(),
            connect.getUserId(),
            connect.isRootOwner(),
            name ) ;
    }
    
    /**
     * コネクション名一覧を取得.
     * <BR><BR>
     * コネクション名一覧を取得します.
     * <BR>
     * @return String[] コネクション名一覧が返されます.
     */
    public String[] getNames() {
        if( connect == null || connect.isOpen() == false ) {
            return null ;
        }
        
        try {
            return ExecutionConnect.getNames(
                connect.getConnect(),
                connect.getUserId(),
                connect.isRootOwner() ) ;
        } catch( Exception e ) {
            return null ;
        }
    }
    
    /**
     * コネクション情報サイズを取得.
     * <BR><BR>
     * コネクション情報サイズを取得します.
     * <BR>
     * @return int コネクション情報数が返されます.
     */
    public int size() {
        if( connect == null || connect.isOpen() == false ) {
            return 0 ;
        }
        
        try {
            return ExecutionConnect.getSize(
                connect.getConnect(),
                connect.getUserId(),
                connect.isRootOwner() ) ;
        } catch( Exception e ) {
            return 0 ;
        }
    }
    
    /**
     * コネクション名が存在するかチェック.
     * <BR><BR>
     * コネクション名が存在するかチェックします.
     * <BR>
     * @param name チェック対象のコネクション名を設定します.
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、存在します.<BR>
     *                 [false]が返された場合、存在しません.
     * @exception MaachangQException MaachangQ例外.
     */
    public boolean isConnect( String name )
        throws MaachangQException {
        if( connect == null || connect.isOpen() == false ) {
            return false ;
        }
        
        return ExecutionConnect.isConnect(
            connect.getConnect(),
            connect.getUserId(),
            connect.isRootOwner(),
            name ) ;
    }
    
    /**
     * 管理コネクションオブジェクトを取得.
     * <BR><BR>
     * 管理コネクションオブジェクトを取得します.
     * <BR>
     * @return MaachangQConnectAdmin 管理コネクションオブジェクトが返されます.
     */
    public MaachangQConnectAdmin getMaachangQConnectAdmin() {
        if( connect == null || connect.isOpen() == false ) {
            return null ;
        }
        return connect ;
    }
    
}

