/*
 * @(#)AdminChannelBean.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.protocol.admin ;

import java.net.InetAddress;

/**
 * 管理者用チャネルBean.
 *  
 * @version 2007/01/05
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class AdminChannelBean extends BaseAdminProtocolBean {
    
    /**
     * チャネルタイプ.
     */
    private int channelType = -1 ;
    
    /**
     * キューマネージャ名.
     */
    private String queueManager = null ;
    
    /**
     * 接続先ホスト.
     */
    private String host = null ;
    
    /**
     * 接続先ポート.
     */
    private int port = -1 ;
    
    /**
     * コネクション名.
     */
    private String connectName = null ;
    
    /**
     * 利用暗号ワード.
     */
    private String useCb32Word = null ;
    
    /**
     * 数値パラメータ.
     */
    private int[] numbers = null ;
    
    /**
     * ステータス情報.
     */
    private int state = -1 ;
    
    /**
     * コンストラクタ.
     */
    public AdminChannelBean() {
        
    }
    
    /**
     * host を取得.
     * <BR><BR>
     * @return host が返されます.
     */
    public InetAddress getInetAddress() {
        if( host != null && ( host = host.trim() ).length() > 0 ) {
            try {
                return InetAddress.getByName( host ) ;
            } catch( Exception e ) {
            }
        }
        return null ;
    }

    /**
     * channelType を取得.
     * <BR><BR>
     * @return channelType が返されます.
     */
    public int getChannelType() {
        return channelType;
    }

    /**
     * channelType を設定.
     * <BR><BR>
     * @param channelType channelType を設定します.
     */
    public void setChannelType(int channelType) {
        this.channelType = channelType;
    }

    /**
     * connectName を取得.
     * <BR><BR>
     * @return connectName が返されます.
     */
    public String getConnectName() {
        return connectName;
    }

    /**
     * connectName を設定.
     * <BR><BR>
     * @param connectName connectName を設定します.
     */
    public void setConnectName(String connectName) {
        this.connectName = connectName;
    }

    /**
     * host を取得.
     * <BR><BR>
     * @return host が返されます.
     */
    public String getHost() {
        return host;
    }

    /**
     * host を設定.
     * <BR><BR>
     * @param host host を設定します.
     */
    public void setHost(String host) {
        this.host = host;
    }

    /**
     * port を取得.
     * <BR><BR>
     * @return port が返されます.
     */
    public int getPort() {
        return port;
    }

    /**
     * port を設定.
     * <BR><BR>
     * @param port port を設定します.
     */
    public void setPort(int port) {
        this.port = port;
    }

    /**
     * numbers を取得.
     * <BR><BR>
     * @return numbers が返されます.
     */
    public int[] getNumbers() {
        return numbers;
    }

    /**
     * numbers を設定.
     * <BR><BR>
     * @param numbers numbers を設定します.
     */
    public void setNumbers(int[] numbers) {
        this.numbers = numbers;
    }

    /**
     * state を取得.
     * <BR><BR>
     * @return state が返されます.
     */
    public int getState() {
        return state;
    }

    /**
     * state を設定.
     * <BR><BR>
     * @param state state を設定します.
     */
    public void setState(int state) {
        this.state = state;
    }

    /**
     * queueManager を取得.
     * <BR><BR>
     * @return queueManager が返されます.
     */
    public String getQueueManager() {
        return queueManager;
    }

    /**
     * queueManager を設定.
     * <BR><BR>
     * @param queueManager queueManager を設定します.
     */
    public void setQueueManager(String queueManager) {
        this.queueManager = queueManager;
    }

    /**
     * useCb32Word を取得.
     * <BR><BR>
     * @return useCb32Word が返されます.
     */
    public String getUseCb32Word() {
        return useCb32Word;
    }

    /**
     * useCb32Word を設定.
     * <BR><BR>
     * @param useCb32Word useCb32Word を設定します.
     */
    public void setUseCb32Word(String useCb32Word) {
        this.useCb32Word = useCb32Word;
    }
    
}
