/*
 * @(#)LoginBean.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.protocol.login ;

/**
 * ログインBean.
 *  
 * @version 2007/01/05
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class LoginBean {
    
    /**
     * ユーザ名.
     */
    private String user = null ;
    
    /**
     * パスワード(SHA1).
     */
    private byte[] passwd = null ;
    
    /**
     * ユーザID.
     */
    private int id = -1 ;
    
    /**
     * ルートオーナー.
     */
    private boolean rootOwner = false ;
    
    /**
     * 処理タイプ.
     */
    private int type = -1 ;
    
    /**
     * シャットダウンコマンド.
     */
    private boolean shutdown = false ;
    
    /**
     * 電文ID.
     */
    private int telegramId = -1 ;
    
    /**
     * コンストラクタ.
     */
    public LoginBean() {
        
    }

    /**
     * passwd を取得.
     * <BR><BR>
     * @return passwd が返されます.
     */
    public byte[] getPasswd() {
        return passwd;
    }

    /**
     * passwd を設定.
     * <BR><BR>
     * @param passwd passwd を設定します.
     */
    public void setPasswd(byte[] passwd) {
        this.passwd = passwd;
    }

    /**
     * user を取得.
     * <BR><BR>
     * @return user が返されます.
     */
    public String getUser() {
        return user;
    }

    /**
     * user を設定.
     * <BR><BR>
     * @param user user を設定します.
     */
    public void setUser(String user) {
        this.user = user;
    }

    /**
     * id を取得.
     * <BR><BR>
     * @return id が返されます.
     */
    public int getId() {
        return id;
    }

    /**
     * id を設定.
     * <BR><BR>
     * @param id id を設定します.
     */
    public void setId(int id) {
        this.id = id;
    }

    /**
     * rootOwner を取得.
     * <BR><BR>
     * @return rootOwner が返されます.
     */
    public boolean isRootOwner() {
        return rootOwner;
    }

    /**
     * rootOwner を設定.
     * <BR><BR>
     * @param rootOwner rootOwner を設定します.
     */
    public void setRootOwner(boolean rootOwner) {
        this.rootOwner = rootOwner;
    }

    /**
     * type を取得.
     * <BR><BR>
     * @return type が返されます.
     */
    public int getType() {
        return type;
    }

    /**
     * type を設定.
     * <BR><BR>
     * @param type type を設定します.
     */
    public void setType(int type) {
        this.type = type;
    }

    /**
     * shutdown を取得.
     * <BR><BR>
     * @return shutdown が返されます.
     */
    public boolean isShutdown() {
        return shutdown;
    }

    /**
     * shutdown を設定.
     * <BR><BR>
     * @param shutdown shutdown を設定します.
     */
    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    /**
     * telegramId を取得.
     * <BR><BR>
     * @return telegramId が返されます.
     */
    public int getTelegramId() {
        return telegramId;
    }

    /**
     * telegramId を設定.
     * <BR><BR>
     * @param telegramId telegramId を設定します.
     */
    public void setTelegramId(int telegramId) {
        this.telegramId = telegramId;
    }
    
}

