/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import java.util.Enumeration;
import org.maachang.dbm.engine.FnvHash;
import org.maachang.dbm.engine.KeyLock;
import org.maachang.dbm.engine.MDbmEnumeration;
import org.maachang.dbm.engine.MKey;
import org.maachang.dbm.engine.MKeyChild;
import org.maachang.dbm.engine.MSctArray;
import org.maachang.dbm.engine.MValue;
import org.maachang.dbm.engine.NextKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDbmEngine {
    public static final int MAX_KEY_LENGTH = 512;
    private MKey key = null;
    private MValue value = null;
    private final KeyLock nsync = new KeyLock();
    private final Object sync = new Object();

    private MDbmEngine() {
    }

    public MDbmEngine(MKey key, MValue value) throws Exception {
        if (key == null || !key.isUse() || value == null || !value.isUse()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.key = key;
        this.value = value;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.sync;
        synchronized (object) {
            if (this.key != null) {
                this.key.destroy();
            }
            if (this.value != null) {
                this.value.destroy();
            }
            this.key = null;
            this.value = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws Exception {
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.key.flush();
            this.value.flush();
        }
    }

    public void put(byte[] key, byte[] value) throws Exception {
        this.nsync.lock(key);
        try {
            this.putValue(key, value);
        }
        finally {
            this.nsync.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putValue(byte[] key, byte[] value) throws Exception {
        if (key == null || key.length <= 0 || value == null || value.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (key.length > 512) {
            throw new IllegalArgumentException("\u6700\u5927\u30ad\u30fc\u9577[512]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
        }
        int code = this.getHash(key);
        if (this.key.get(code, key) == null && !this.key.putCheck(1)) {
            throw new IOException("\u683c\u7d0d\u6700\u5927\u6570[9500000]\u3092\u8d8a\u3057\u3066\u3044\u308b\u305f\u3081\u3001put\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (!this.value.putCheck(MSctArray.sectorLength(value.length))) {
            throw new IOException("\u5bb9\u91cf\u304c\u8db3\u308a\u306a\u3044\u305f\u3081put\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        int[] putPos = this.value.put(value);
        int[] befPos = this.key.put(code, key, putPos[0], putPos[1], putPos[2], putPos[3], value.length);
        if (befPos != null) {
            this.value.remove(befPos[0], befPos[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(byte[] key) throws Exception {
        if (key == null || key.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (key.length > 512) {
            throw new IllegalArgumentException("\u6700\u5927\u30ad\u30fc\u9577[512]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        this.nsync.lock(key);
        try {
            Object object = this.sync;
            synchronized (object) {
                if (!this.check()) {
                    throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
                }
            }
            int code = this.getHash(key);
            int[] valPos = this.key.remove(code, key);
            if (valPos != null) {
                this.value.remove(valPos[0], valPos[1]);
            }
        }
        finally {
            this.nsync.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(byte[] key) throws Exception {
        if (key == null || key.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (key.length > 512) {
            throw new IllegalArgumentException("\u6700\u5927\u30ad\u30fc\u9577[512]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        this.nsync.lock(key);
        try {
            byte[] ret = null;
            Object object = this.sync;
            synchronized (object) {
                if (!this.check()) {
                    throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
                }
            }
            int code = this.getHash(key);
            int[] valPos = this.key.get(code, key);
            if (valPos != null) {
                ret = this.value.get(valPos[0], valPos[1], valPos[4]);
            }
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            this.nsync.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength(byte[] key) throws Exception {
        if (key == null || key.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (key.length > 512) {
            throw new IllegalArgumentException("\u6700\u5927\u30ad\u30fc\u9577[512]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        this.nsync.lock(key);
        try {
            int ret = 0;
            Object object = this.sync;
            synchronized (object) {
                if (!this.check()) {
                    throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
                }
            }
            int code = this.getHash(key);
            int[] valPos = this.key.get(code, key);
            if (valPos != null) {
                ret = valPos[4];
            }
            int n = ret;
            return n;
        }
        finally {
            this.nsync.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(byte[] key) throws Exception {
        if (key == null || key.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (key.length > 512) {
            throw new IllegalArgumentException("\u6700\u5927\u30ad\u30fc\u9577[512]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        this.nsync.lock(key);
        try {
            boolean ret = false;
            Object object = this.sync;
            synchronized (object) {
                if (!this.check()) {
                    throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
                }
            }
            int code = this.getHash(key);
            if (this.key.get(code, key) != null) {
                ret = true;
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.nsync.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(byte[] key, byte[] value, int off, int length) throws Exception {
        if (key == null || key.length <= 0 || value == null || value.length <= 0 || off < 0 || length <= 0 || off + length > value.length) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (key.length > 512) {
            throw new IllegalArgumentException("\u6700\u5927\u30ad\u30fc\u9577[512]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        this.nsync.lock(key);
        try {
            Object object = this.sync;
            synchronized (object) {
                if (!this.check()) {
                    throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
                }
            }
            int code = this.getHash(key);
            if (!this.value.putCheck(MSctArray.sectorLength(length))) {
                throw new IOException("\u5bb9\u91cf\u304c\u8db3\u308a\u306a\u3044\u305f\u3081put\u51e6\u7406\u306f\u3067\u304d\u307e\u305b\u3093");
            }
            MKeyChild ch = this.key.getChild(code, key);
            if (ch == null) {
                byte[] b = new byte[length];
                System.arraycopy(value, off, b, 0, length);
                this.putValue(key, b);
                b = null;
            } else {
                this.value.addLast(ch, value, off, length);
                this.key.saveChild(ch);
            }
        }
        finally {
            this.nsync.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] key, byte[] value, int pos, int off, int length) throws Exception {
        if (key == null || key.length <= 0 || value == null || value.length <= 0 || off < 0 || length <= 0 || off + length > value.length) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (key.length > 512) {
            throw new IllegalArgumentException("\u6700\u5927\u30ad\u30fc\u9577[512]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        this.nsync.lock(key);
        try {
            Object object = this.sync;
            synchronized (object) {
                if (!this.check()) {
                    throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
                }
            }
            int code = this.getHash(key);
            MKeyChild ch = this.key.getChild(code, key);
            if (ch == null) {
                throw new IOException("\u6307\u5b9a\u30ad\u30fc\u306e\u5185\u5bb9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            int n = this.value.write(ch, value, pos, off, length);
            return n;
        }
        finally {
            this.nsync.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] key, byte[] value, int pos, int off, int length) throws Exception {
        if (key == null || key.length <= 0 || value == null || value.length <= 0 || off < 0 || length <= 0 || off + length > value.length) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (key.length > 512) {
            throw new IllegalArgumentException("\u6700\u5927\u30ad\u30fc\u9577[512]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        this.nsync.lock(key);
        try {
            Object object = this.sync;
            synchronized (object) {
                if (!this.check()) {
                    throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
                }
            }
            int code = this.getHash(key);
            MKeyChild ch = this.key.getChild(code, key);
            if (ch == null) {
                throw new IOException("\u6307\u5b9a\u30ad\u30fc\u306e\u5185\u5bb9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            int n = this.value.read(ch, value, pos, off, length);
            return n;
        }
        finally {
            this.nsync.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextKey next(NextKey nextKey) throws Exception {
        NextKey ret = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
        }
        ret = this.key.nextKey(nextKey);
        return ret;
    }

    public Enumeration<byte[]> elements() {
        return new MDbmEnumeration(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sequenceId(int no) throws Exception {
        long ret = -1L;
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            ret = this.key.getMHash().sequenceId(no);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int ret = -1;
        Object object = this.sync;
        synchronized (object) {
            if (this.check()) {
                ret = this.key.size();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MKey getMKey() {
        MKey ret = null;
        Object object = this.sync;
        synchronized (object) {
            if (this.check()) {
                ret = this.key;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MValue getMValue() {
        MValue ret = null;
        Object object = this.sync;
        synchronized (object) {
            if (this.check()) {
                ret = this.value;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUse() {
        boolean ret = false;
        Object object = this.sync;
        synchronized (object) {
            ret = this.check();
        }
        return ret;
    }

    public Object sync() {
        return this.sync;
    }

    public static final int convertLengthBySectorLength(int length) {
        return MSctArray.sectorLength(length);
    }

    public static final int getBinaryHash(byte[] binary) throws Exception {
        if (binary == null || binary.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (binary.length > 512) {
            throw new IllegalArgumentException("\u6700\u5927\u30ad\u30fc\u9577[512]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        return FnvHash.fnv32a(binary);
    }

    public void addChecks(int addKeyLength, int addSectorLength) throws Exception {
        if (addKeyLength > 0 && !this.key.putCheck(addKeyLength)) {
            throw new IOException("\u683c\u7d0d\u6700\u5927\u6570[9500000]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        if (addSectorLength > 0 && !this.value.putCheck(addSectorLength)) {
            throw new IOException("\u30c7\u30fc\u30bf\u8ffd\u52a0\u306b\u5bfe\u3057\u3066\u3001\u5bb9\u91cf\u304c\u8db3\u308a\u307e\u305b\u3093[" + addSectorLength + "]");
        }
    }

    private boolean check() {
        return this.key != null && this.key.isUse() && this.value != null && this.value.isUse();
    }

    private int getHash(byte[] key) {
        return FnvHash.fnv32a(key);
    }
}

