/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.service;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import org.maachang.dbm.MDbmManager;
import org.maachang.dbm.service.MDbmServer;
import org.maachang.dbm.service.MDbmShutdown;
import org.maachang.dbm.service.down.ShutdownHook;
import org.maachang.dbm.service.down.WaitShutdown;
import org.maachang.util.conf.Config;
import org.maachang.util.conf.ReadIni;

public class MDbmServerProcess {
    private static final String CONFIG = "conf/mdbm.conf";

    private MDbmServerProcess() {
    }

    public static final void main(String[] args) {
        System.out.println("*** start maachang DBM.");
        try {
            new MDbmServerProcess().execution(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("*** exit maachang DBM.");
    }

    private void execution(String[] args) throws Exception {
        Config conf = MDbmServerProcess.readConfig();
        MDbmServer server = MDbmServerProcess.createServer(conf);
        ShutdownHook hook = ShutdownHook.registHook(new MDbmShutdown(server));
        WaitShutdown waitDown = new WaitShutdown(MDbmServerProcess.getShutdownPort(conf));
        conf = null;
        while (!waitDown.isShutdown()) {
        }
        hook.getShutdownCallback().execution();
        waitDown.exitShutdown();
    }

    private static final Config readConfig() throws Exception {
        Config ret = null;
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(CONFIG), "UTF8"));
            ret = new Config();
            ReadIni.analisys(ret, r);
            r.close();
            r = null;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
            r = null;
        }
        return ret;
    }

    private static final MDbmServer createServer(Config conf) throws Exception {
        String dir = conf.get("mdbm", "directory", 0);
        InetAddress addr = conf.getInetAddress("mdbm", "bind-addr", 0);
        int port = conf.getInt("mdbm", "bind-port", 0);
        int max = conf.getInt("mdbm", "max", 0);
        int pool = conf.getInt("mdbm", "pool", 0);
        if (dir == null || (dir = dir.trim()).length() <= 0) {
            throw new IOException("MDBM\u30c7\u30fc\u30bf\u4fdd\u5b58\u7528\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u4e0d\u6b63\u3067\u3059");
        }
        MDbmManager.getInstance().open(dir);
        MDbmServer ret = new MDbmServer(addr, port, max, pool);
        System.out.println("directory:" + dir);
        System.out.println("bind-addr:" + ret.getInetAddress().getHostAddress());
        System.out.println("bind-port:" + ret.getLocalPort());
        System.out.println("max:" + max);
        System.out.println("pool:" + pool);
        return ret;
    }

    protected static final int getShutdownPort(Config conf) throws Exception {
        if (conf == null) {
            conf = MDbmServerProcess.readConfig();
        }
        return conf.getInt("mdbm", "shutdown-port", 0);
    }
}

