/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.service;

import org.maachang.dbm.service.DbmSession;
import org.maachang.dbm.service.ReceiveQueue;
import org.maachang.dbm.service.SocketManager;

class ReceiveThread
extends Thread {
    private volatile boolean stopFlag = true;
    private ReceiveQueue queue = null;
    private SocketManager man = null;
    private static final long WAIT = 30L;

    private ReceiveThread() {
    }

    public ReceiveThread(SocketManager man, ReceiveQueue queue) throws Exception {
        if (man == null || man.isClosed() || queue == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.man = man;
        this.queue = queue;
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    public void run() {
        boolean endFlag = false;
        ThreadDeath threadDeach = null;
        block10: while (!endFlag && !this.isStop()) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException ie) {
                endFlag = true;
                continue;
            }
            try {
                int len = this.man.size();
                if (len <= 0) continue;
                int i = len - 1;
                while (i >= 0) {
                    if (this.isStop()) continue block10;
                    DbmSession s = null;
                    try {
                        s = this.man.getToRemove(i);
                        if (s != null) {
                            s.heartBeat();
                            if (s.isClosed()) {
                                s.destroy();
                            } else if (s.isReceive()) {
                                this.queue.append(s);
                            } else {
                                this.man.append(s);
                            }
                        }
                    }
                    catch (InterruptedException iee) {
                        throw iee;
                    }
                    catch (Exception ee) {
                        if (s != null) {
                            s.destroy();
                        }
                        s = null;
                    }
                    --i;
                }
            }
            catch (InterruptedException ie) {
                endFlag = true;
            }
            catch (OutOfMemoryError ie) {
            }
            catch (Exception ie) {
            }
            catch (ThreadDeath td) {
                endFlag = true;
                threadDeach = td;
            }
        }
        this.man = null;
        this.queue = null;
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }
}

