package org.maachang.dbm.service ;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;

/**
 * AcceptThread.
 * 
 * @version 2008/01/18
 * @author masahito suzuki
 * @since MaachangDBM 1.03
 */
class AcceptThread extends Thread {
    
    private volatile boolean stopFlag = true ;
    private SocketManager man = null ;
    
    private AcceptThread() {
        
    }
    
    public AcceptThread( SocketManager man )
        throws Exception {
        if( man == null || man.isClosed() == true ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.man = man ;
        this.stopFlag = false ;
        this.setDaemon( true ) ;
        this.start() ;
    }
    
    public void destroy() {
        setStop( true ) ;
    }
    
    public synchronized boolean isStop() {
        return stopFlag ;
    }
    
    private synchronized void setStop( boolean mode ) {
        this.stopFlag = mode ;
    }
    
    public void run() {
        boolean endFlag = false ;
        ThreadDeath threadDeach = null ;
        for( ;; ) {
            if( endFlag == true || isStop() == true ) {
                break ;
            }
            ServerSocket ss = this.man.getServerSocket() ;
            Socket s = null ;
            try {
                if( ( s = ss.accept() ) != null ) {
                    System.out.println(
                        new StringBuilder().
                        append(">>[").append(System.currentTimeMillis()).append("]:accept:").
                        append( s.getInetAddress().getHostName() ).
                        append( "/" ).append( s.getPort() ).toString() ) ;
                    this.man.append( s ) ;
                }
            } catch( SocketTimeoutException st ) {
            } catch ( NullPointerException ne ) {
            } catch( OutOfMemoryError mem ) {
            } catch( Exception e ) {
            } catch( ThreadDeath td ) {
                endFlag = true ;
                threadDeach = td ;
            }
        }
        this.man = null ;
        setStop( true ) ;
        if( threadDeach != null ) {
            throw threadDeach ;
        }
    }
    
}

