package org.maachang.dbm.service ;

/**
 * ReceiveThread.
 * 
 * @version 2008/01/18
 * @author masahito suzuki
 * @since MaachangDBM 1.03
 */
class ReceiveThread extends Thread {
    
    private volatile boolean stopFlag = true ;
    private ReceiveQueue queue = null ;
    private SocketManager man = null ;
    
    private ReceiveThread() {
        
    }
    
    public ReceiveThread( SocketManager man,ReceiveQueue queue )
        throws Exception {
        if( man == null || man.isClosed() == true || queue == null ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.man = man ;
        this.queue = queue ;
        this.stopFlag = false ;
        this.setDaemon( true ) ;
        this.start() ;
    }
    
    public void destroy() {
        setStop( true ) ;
    }
    
    public synchronized boolean isStop() {
        return stopFlag ;
    }
    
    private synchronized void setStop( boolean mode ) {
        this.stopFlag = mode ;
    }
    
    private static final long WAIT = 30L ;
    
    public void run() {
        boolean endFlag = false ;
        ThreadDeath threadDeach = null ;
        for( ;; ) {
            if( endFlag == true || isStop() == true ) {
                break ;
            }
            try { Thread.sleep( WAIT ) ; } catch( InterruptedException ie ) {
                endFlag = true ;
                continue ;
            }
            try {
                int len = this.man.size() ;
                if( len > 0 ) {
                    for( int i = len-1 ; i >= 0 ; i -- ) {
                        if( isStop() == true ) {
                            break ;
                        }
                        DbmSession s = null ;
                        try {
                            s = this.man.getToRemove( i ) ;
                            if( s == null ) {
                                continue ;
                            }
                            s.heartBeat() ;// heartBeat.
                            if( s.isClosed() == true ) {
                                s.destroy() ;
                            }
                            else if( s.isReceive() == true ) {
                                this.queue.append( s ) ;
                            }
                            else {
                                this.man.append( s ) ;
                            }
                        } catch( InterruptedException iee ) {
                            throw iee ;
                        } catch( Exception ee ) {
                            if( s != null ) {
                                s.destroy() ;
                            }
                            s = null ;
                        }
                    }
                }
            } catch( InterruptedException ie ) {
                endFlag = true ;
            } catch( OutOfMemoryError mem ) {
            } catch( Exception e ) {
            } catch( ThreadDeath td ) {
                endFlag = true ;
                threadDeach = td ;
            }
        }
        this.man = null ;
        this.queue = null ;
        setStop( true ) ;
        if( threadDeach != null ) {
            throw threadDeach ;
        }
    }
    
}

