/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.conf.MinStartupConfig;
import org.maachang.comet.httpd.HttpdVersionDef;
import org.maachang.comet.httpd.engine.script.BaseModel;
import org.maachang.comet.httpd.engine.script.BaseModelImpl;
import org.maachang.comet.httpd.engine.script.EndScript;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.WebAppScriptFactory;
import org.maachang.comet.httpd.engine.script.cache.CacheScriptManager;
import org.maachang.comet.httpd.engine.script.dao.DaoFactory;
import org.maachang.manager.GlobalManager;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleScript {
    private static final Log LOG = LogFactory.getLog(ConsoleScript.class);
    private static final String SCRIPT_MEMORYS = "scriptMemorys = Bindings() ;\n";
    private ScriptContext ctx = null;
    private WebAppScriptFactory webApp = null;
    private BaseModel baseModel = null;
    private String path = null;
    private ScriptEngine consoleEngine = null;
    private static final String RELOAD = "reload";
    private static final String EXIT = "exit";
    private static final String MEM = "mem";
    private static final String GC = "gc";
    private static final String LIST = "list";
    private static final String VIEW = "view";
    private static final String CLS = "cls";

    private ConsoleScript() {
    }

    public static final void main(String[] args) throws Exception {
        new ConsoleScript().execution(args);
    }

    private void execution(String[] args) throws Exception {
        this.path = String.valueOf(FileUtil.getFullPath((String)".")) + FileUtil.FILE_SPACE;
        if (args != null && args.length > 0) {
            LOG.info((Object)"## maachang comet - console .. ");
            LOG.info((Object)("## [ver." + HttpdVersionDef.getVersion() + " update." + HttpdVersionDef.getDate() + "]"));
            LOG.info((Object)"##");
        } else {
            System.out.println("maachang comet - console .. ");
            System.out.println("[ver." + HttpdVersionDef.getVersion() + " update." + HttpdVersionDef.getDate() + "]");
            System.out.println();
        }
        MinStartupConfig.init(this.path);
        this.webApp = new WebAppScriptFactory(this.path);
        GlobalManager.getInstance().put("WEBAPP_FACTORY", (Object)this.webApp);
        DaoFactory daoFactory = new DaoFactory();
        GlobalManager.getInstance().put("DAO_FACTORY", (Object)daoFactory);
        this.readScript();
        this.createConsoleEngine();
        if (args != null && args.length > 0) {
            StringBuilder buf = new StringBuilder();
            StringBuilder names = new StringBuilder();
            this.batch(buf);
            buf.append(SCRIPT_MEMORYS);
            int len = args.length;
            int i = 0;
            while (i < len) {
                if (i != 0) {
                    names.append(",");
                }
                names.append(args[i]);
                String str = FileUtil.getFileByString((String)args[i]);
                if (str == null) {
                    throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb\u540d[" + args[i] + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                }
                buf.append(str);
                LOG.info((Object)("## readBatch:" + args[i]));
                ++i;
            }
            String nms = names.toString();
            names = null;
            String script = buf.toString();
            buf = null;
            try {
                this.consoleEngine.put("javax.script.filename", "console[" + nms + "]");
                this.consoleEngine.eval(script, this.ctx);
            }
            catch (Exception e) {
                LOG.error((Object)"## error", (Throwable)e);
            }
        } else {
            this.startConsole();
        }
    }

    private void batch(StringBuilder buf) {
        buf.append("var print = function(info) { org.maachang.comet.ConsoleScript.logout(info); };\n").append("var println = function(info) { org.maachang.comet.ConsoleScript.logout(info); };\n").append("var p = function(info) { org.maachang.comet.ConsoleScript.logout(info); };\n").append("var puts = function(info) { org.maachang.comet.ConsoleScript.logout(info); };\n").append("var alert = function(info) { org.maachang.comet.ConsoleScript.logout(info); };\n");
    }

    public static final void logout(String string) {
        if (string != null && string.length() <= 0) {
            return;
        }
        LOG.info((Object)string);
    }

    private void readScript() throws Exception {
        this.ctx = new SimpleScriptContext();
        this.baseModel = new BaseModelImpl();
        System.out.println("");
        CacheScriptManager.getInstance().executionByExitRequest();
        CacheScriptManager.getInstance().reload();
        CacheScriptManager.getInstance().script(this.ctx);
        this.readDefaultParams();
        ScriptDef.setDirectoryByBindings(this.ctx);
    }

    private void readDefaultParams() throws Exception {
        Bindings bindings = this.ctx.getBindings(100);
        bindings.put("_$current$name", (Object)"console");
        bindings.put("__$type$script", (Object)"console");
        bindings.put("__$detail$script", (Object)"console");
        bindings.put("_$script$base_model", (Object)this.baseModel);
        bindings.put("_$script$path", (Object)this.path);
        bindings.put("_$script$context", (Object)this.ctx);
        bindings.put("log", (Object)LOG);
    }

    private void createConsoleEngine() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        this.consoleEngine = manager.getEngineByName("js");
        Bindings bindings = this.ctx.getBindings(100);
        bindings.put("_$script$engine", (Object)this.consoleEngine);
        this.consoleEngine.eval(SCRIPT_MEMORYS, this.ctx);
    }

    private void startConsole() throws Exception {
        StringBuilder buf = null;
        System.out.println();
        BufferedReader bo = new BufferedReader(new InputStreamReader(System.in));
        block3: while (true) {
            System.out.print("$>");
            String one = bo.readLine();
            if (one == null || (one = one.trim()).length() <= 0) continue;
            String ck = one.toLowerCase();
            if (EXIT.equals(ck)) {
                if (this.baseModel.isCreate()) {
                    this.baseModel.commit();
                }
                System.out.println(" ... success exit");
                return;
            }
            if (ck.startsWith("!")) {
                String[] strs;
                Object[] objs;
                if (RELOAD.equals(ck = ck.substring("!".length(), ck.length()))) {
                    this.readScript();
                    this.createConsoleEngine();
                    System.out.println(" ... success reload");
                    continue;
                }
                if (EXIT.equals(ck)) {
                    if (this.baseModel.isCreate()) {
                        this.baseModel.commit();
                    }
                    System.out.println(" ... success exit");
                    return;
                }
                if (MEM.equals(ck)) {
                    Bindings bindings = this.ctx.getBindings(100);
                    System.out.println("+-------------------------------------------");
                    objs = CacheScriptManager.getInstance().getWrapper().getAllKey();
                    int i = 0;
                    while (i < objs.length) {
                        System.out.println(objs[i] + " : " + bindings.get(objs[i]));
                        ++i;
                    }
                    System.out.println("+-------------------------------------------");
                    System.out.println("total:" + Runtime.getRuntime().totalMemory());
                    System.out.println("max  :" + Runtime.getRuntime().maxMemory());
                    System.out.println("free :" + Runtime.getRuntime().freeMemory());
                    continue;
                }
                if (LIST.equals(ck)) {
                    Bindings bindings = this.ctx.getBindings(100);
                    objs = CacheScriptManager.getInstance().getWrapper().getAllKey();
                    if (objs == null) continue;
                    ArrayList<String> lst = new ArrayList<String>();
                    int i = 0;
                    while (i < objs.length) {
                        if (bindings.get(objs[i]) != null && bindings.get(objs[i]).getClass().getName().indexOf(".InterpretedFunction") != -1) {
                            lst.add((String)objs[i]);
                        }
                        ++i;
                    }
                    strs = ConsoleScript.sort(lst);
                    lst = null;
                    ConsoleScript.outputView(strs);
                    continue;
                }
                if (VIEW.equals(ck)) {
                    Bindings bindings = this.ctx.getBindings(100);
                    objs = CacheScriptManager.getInstance().getWrapper().getAllKey();
                    if (objs == null) continue;
                    ArrayList<String> lst = new ArrayList<String>();
                    int i = 0;
                    while (i < objs.length) {
                        String st;
                        if (bindings.get(objs[i]) != null && (st = bindings.get(objs[i]).getClass().getName()).indexOf(".InterpretedFunction") == -1 && ((String)objs[i]).indexOf("_") == -1 && ((String)objs[i]).indexOf("$") == -1) {
                            lst.add((String)objs[i]);
                        }
                        ++i;
                    }
                    strs = ConsoleScript.sort(lst);
                    lst = null;
                    ConsoleScript.outputView(strs);
                    continue;
                }
                if (GC.equals(ck)) {
                    Runtime.getRuntime().gc();
                    continue;
                }
                if (CLS.equals(ck)) {
                    int i = 0;
                    while (true) {
                        if (i >= 120) continue block3;
                        System.out.println();
                        ++i;
                    }
                }
                if (one.length() == 1) {
                    System.out.println("** help ************************************");
                    System.out.println("!reload : \u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u518d\u8aad\u307f\u8fbc\u307f.");
                    System.out.println("!exit   : \u30b9\u30af\u30ea\u30d7\u30c8\u3092\u7d42\u4e86.");
                    System.out.println("!mem    : \u30e1\u30e2\u30ea\u60c5\u5831\u3092\u51fa\u529b.");
                    System.out.println("!gc     : \u30ac\u30da\u30fc\u30b8\u30b3\u30ec\u30af\u30bf\u30fc\u3092\u5b9f\u884c.");
                    System.out.println("!list   : \u6709\u52b9\u30e1\u30bd\u30c3\u30c9\u4e00\u89a7.");
                    System.out.println("!view   : \u6709\u52b9\u5909\u6570\u4e00\u89a7.");
                    System.out.println("!cls    : \u753b\u9762\u30af\u30ea\u30a2.");
                    System.out.println("** help ************************************");
                    System.out.println();
                    continue;
                }
            }
            if (one.endsWith("\\")) {
                if (buf == null) {
                    buf = new StringBuilder();
                }
                buf.append(one.substring(0, one.length() - 1)).append("\n");
                continue;
            }
            if (buf != null) {
                buf.append(one).append("\n");
                one = buf.toString();
            }
            buf = null;
            try {
                this.consoleEngine.put("javax.script.filename", "console");
                Object obj = this.consoleEngine.eval(one, this.ctx);
                if (obj != null) {
                    System.out.println(obj);
                    continue;
                }
                System.out.println();
                continue;
            }
            catch (ScriptException sc) {
                if (EndScript.isEndScript(sc)) {
                    if (this.baseModel.isCreate()) {
                        this.baseModel.commit();
                    }
                    System.out.println("... exit");
                    return;
                }
                System.out.println(sc.getMessage());
                continue;
            }
            catch (Exception e) {
                System.out.println(e);
                continue;
            }
            break;
        }
    }

    private static final String[] sort(ArrayList<String> lst) {
        Object[] strs = null;
        int len = lst.size();
        if (len > 0) {
            strs = new String[len];
            int i = 0;
            while (i < len) {
                strs[i] = lst.get(i);
                ++i;
            }
            Arrays.sort(strs);
        }
        return strs;
    }

    private static final void outputView(String[] strs) {
        int cnt = 0;
        if (strs != null) {
            int i = 0;
            while (i < strs.length) {
                String view = strs[i];
                int viewLen = view.length();
                view = viewLen <= 16 ? "[" + view + "] " + StringUtil.createString((char)' ', (int)(16 - viewLen)) : "[" + view + "] " + StringUtil.createString((char)' ', (int)(38 - (viewLen + 3)));
                System.out.print(view);
                if ((cnt += view.length()) >= 75) {
                    System.out.println();
                    cnt = 0;
                }
                ++i;
            }
            System.out.println();
        }
        System.out.println();
    }
}

