/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet;

import org.maachang.comet.conf.BaseConfig;
import org.maachang.comet.conf.IniFile;
import org.maachang.comet.conf.StartupConfig;
import org.maachang.dao.dbms.RecordFactory;
import org.maachang.dao.dbms.ctbl.CreateTable;
import org.maachang.util.FileUtil;

public class OutputTable {
    private OutputTable() {
    }

    public static final void main(String[] args) throws Exception {
        new OutputTable().execution(args);
    }

    private void execution(String[] args) throws Exception {
        String basePath = StartupConfig.getPath(".");
        RecordFactory factory = this.getRecordFactory(basePath);
        if (factory == null) {
            System.out.println("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a\u304c\u7121\u52b9\u3067\u3059.");
            return;
        }
        String tablePath = String.valueOf(basePath) + "table/";
        String modelPath = String.valueOf(basePath) + "model/";
        String param = null;
        param = args == null || args.length <= 0 ? null : args[0];
        CreateTable.create((boolean)false, (String)tablePath, (String)modelPath, (String)param, (RecordFactory)factory);
        factory.clear();
    }

    private RecordFactory getRecordFactory(String path) throws Exception {
        path = String.valueOf(path) + "conf/";
        path = String.valueOf(FileUtil.getFullPath((String)path)) + FileUtil.FILE_SPACE;
        BaseConfig bconf = StartupConfig.getBaseConfig(path);
        int len = bconf.size();
        IniFile config = new IniFile();
        int i = 0;
        while (i < len) {
            String name = bconf.getConfig(i);
            if (name != null && (name = name.trim()).length() > 0) {
                StartupConfig.readConfig(config, path, name);
            }
            ++i;
        }
        return StartupConfig.getRecordFactory(false, config);
    }
}

