/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.conf;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.util.FileUtil;

public class MimeConfig {
    public static final String OPTION_GZIP = "gzip.";
    private static final String READ_FILE = "conf/mime.conf";
    private static final String CHARSET = "UTF8";
    private static final String BASE_SECTION = "mime-type";
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private Config iniParams = null;
    private String fileName = null;
    private long lastUpdate = -1L;

    public synchronized void open() throws Exception {
        this.open(READ_FILE);
    }

    public synchronized void open(String name) throws Exception {
        this.fileName = FileUtil.getFullPath((String)name);
        try {
            this.reload();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public synchronized void close() {
        this.iniParams = null;
        this.fileName = null;
        this.lastUpdate = -1L;
    }

    public synchronized String get(String name) {
        try {
            long tm = FileUtil.getLastTime((String)this.fileName);
            if (this.lastUpdate != tm) {
                this.reload();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.iniParams.get(BASE_SECTION, name, 0);
    }

    public synchronized String getNameByMimeType(String name) {
        String ret;
        String plus;
        try {
            long tm = FileUtil.getLastTime((String)this.fileName);
            if (this.lastUpdate != tm) {
                this.reload();
            }
        }
        catch (Exception tm) {
            // empty catch block
        }
        if ((plus = MimeConfig.getPlus(name)) == null) {
            plus = name;
        }
        if ((ret = this.iniParams.get(BASE_SECTION, plus, 0)) == null) {
            ret = DEFAULT_MIME_TYPE;
        }
        return ret;
    }

    private final void reload() throws Exception {
        BufferedReader buf = null;
        if (FileUtil.isFileExists((String)this.fileName)) {
            try {
                buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), CHARSET));
                Config iniParams = new Config();
                ReadIni.analisys((Config)iniParams, (BufferedReader)buf);
                buf.close();
                buf = null;
                long last = FileUtil.getLastTime((String)this.fileName);
                this.iniParams = iniParams;
                this.lastUpdate = last;
            }
            finally {
                if (buf != null) {
                    try {
                        buf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static final String getPlus(String name) {
        int p = name.lastIndexOf(".");
        if (p == -1) {
            return null;
        }
        return name.substring(p + 1, name.length());
    }

    public String toString() {
        if (this.iniParams != null) {
            return this.iniParams.toString();
        }
        return "null";
    }
}

