/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.comet;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.comet.Comet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimeoutCometMonitor
extends Thread {
    private static final Log LOG = LogFactory.getLog(TimeoutCometMonitor.class);
    private static final long TIME = 30000L;
    private Map<String, Comet> manager = null;
    private long beforeTime = System.currentTimeMillis();
    private volatile boolean stopFlag = false;
    private Object stopSync = new Object();
    private static final long IDLE_TIME = 500L;

    public TimeoutCometMonitor(Map<String, Comet> manager) {
        this.manager = manager;
        this.setDaemon(true);
        this.start();
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public void clear() {
        this.stopThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopThread() {
        boolean ret = false;
        Object object = this.stopSync;
        synchronized (object) {
            ret = this.stopFlag;
        }
        return ret;
    }

    @Override
    public void run() {
        block20: {
            block14: while (true) {
                while (true) {
                    if (this.isStopThread()) {
                        break block20;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (this.beforeTime + 30000L > System.currentTimeMillis()) continue block14;
                        try {
                            if (this.manager == null || this.manager.size() <= 0) continue block14;
                            Object[] objs = this.manager.keySet().toArray();
                            int len = objs.length;
                            int i = 0;
                            while (true) {
                                if (i >= len) continue block14;
                                if (this.isStopThread()) continue block14;
                                try {
                                    Thread.sleep(30L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                Comet comet = this.manager.get((String)objs[i]);
                                if (comet == null) {
                                    this.manager.remove((String)objs[i]);
                                } else {
                                    objs[i] = null;
                                    comet.cleanConnection();
                                }
                                ++i;
                            }
                        }
                        finally {
                            this.beforeTime = System.currentTimeMillis();
                            continue block14;
                        }
                    }
                    catch (OutOfMemoryError mm) {
                        LOG.error((Object)"OutOfMemoryError", (Throwable)mm);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"error", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            finally {
                LOG.warn((Object)("## stopThread:" + this.getClass().getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThread() {
        Object object = this.stopSync;
        synchronized (object) {
            this.stopFlag = true;
        }
    }
}

