/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.maachang.comet.httpd.HttpdParams;
import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.util.Digest;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptDef {
    public static final String SCRIPT_BY_LOG = "log";
    public static final String SCRIPT_MODE = "__$type$script";
    public static final String SCRIPT_DETAIL = "__$detail$script";
    public static final String CURRENT_SCRIPT = "_$current$name";
    public static final String MODE_COMET = "comet";
    public static final String MODE_NOT_COMET = "script";
    public static final String MODE_CONSOLE = "console";
    public static final String MANAGER = "_$$maachang_comet_manager";
    public static final String SCRIPT_BY_MODEL = "_$script$base_model";
    public static final String SCRIPT_BY_ENGINE = "_$script$engine";
    public static final String SCRIPT_BY_CTX = "_$script$context";
    public static final String SCRIPT_BY_SESSION = "_$script$session";
    public static final String SCRIPT_BY_HEADER = "_$script$header";
    public static final String SCRIPT_BY_PATH = "_$script$path";
    public static final String SCRIPT_BY_GROUP_ID = "_$script$group_id";
    public static final String SCRIPT_BY_COMET_ARGS = "_$script$comet_args";
    public static final String SCRIPT_BY_RESPONSE = "_$script$response";
    public static final String SCRIPT_BY_REQUEST = "_$script$request";
    public static final String SCRIPT_BY_QUERY = "_$script$query";
    public static final String SCRIPT_STARTUP = "_$startup$params";
    public static final String ENGINE_JAVASCRIPT = "js";
    public static final String SCRIPT_PLUS = ".ms";
    public static final String SCRIPT_HTML_PLUS = ".mhtml";
    public static final String SCRIPT_BY_COMET = "Comet";
    public static final String SCRIPT_BY_JCOMET = "JComet";
    public static final String SCRIPT_BY_TRIGGER = "Trigger";
    public static final String SCRIPT_BY_AJAX = "Ajax";
    public static final String SCRIPT_BY_CONTROLLER = "Controller";
    public static final String SCRIPT_BY_JSONP = "Jsonp";
    public static final String SCRIPT_BY_INNER = "Inner";
    public static final String SCRIPT_BY_FILTER = "Filter";
    public static final int SCRIPT_TYPE_BY_NOT = -1;
    public static final int SCRIPT_TYPE_BY_DEFAULT = 0;
    public static final int SCRIPT_TYPE_BY_COMET = 1;
    public static final int SCRIPT_TYPE_BY_AJAX = 2;
    public static final int SCRIPT_TYPE_BY_CONTROLLER = 3;
    public static final int SCRIPT_TYPE_BY_JSONP = 4;
    public static final int SCRIPT_TYPE_BY_HTML = 10;
    public static final int SCRIPT_TYPE_BY_MODEL = 20;
    public static final int SCRIPT_TYPE_BY_LIB = 30;
    public static final int SCRIPT_TYPE_BY_COMET_TRIGGER = 31;
    public static final int SCRIPT_TYPE_BY_INNER = 32;
    public static final int SCRIPT_TYPE_BY_FILTER = 98;
    public static final int SCRIPT_TYPE_BY_ETC = 99;
    public static final String FILTER_NAME = "filter";
    public static final String SCRIPT_RESULT_REDIRECT = "redirect";
    public static final String SCRIPT_RESULT_FORWARD = "forward";
    public static final String SCRIPT_RESULT_ERROR = "error";
    public static final String ADD_SCRIPT = "scriptMemorys = Bindings() ;\nvar params = jmap(_$script$query);\nvar sessions = sessionMap();\n";

    private ScriptDef() {
    }

    public static final String trimCurrentDirectory(String directory) throws Exception {
        if (directory == null || (directory = directory.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5bfe\u8c61\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d\u306f\u4e0d\u6b63\u3067\u3059");
        }
        directory = FileUtil.getFullPath((String)directory);
        if (!(directory = StringUtil.changeString((String)directory, (String)"\\", (String)"/")).startsWith("/")) {
            directory = "/" + directory;
        }
        if (!directory.endsWith("/")) {
            directory = String.valueOf(directory) + "/";
        }
        return directory;
    }

    public static final int getScriptByAllTyep(String name) {
        if (name.endsWith(SCRIPT_HTML_PLUS)) {
            return 10;
        }
        if (!name.endsWith(SCRIPT_PLUS)) {
            name = String.valueOf(name) + SCRIPT_PLUS;
        }
        return ScriptDef.getScriptFileType(name);
    }

    public static final int getScriptFileType(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return -1;
        }
        String check = null;
        if (!name.endsWith(SCRIPT_PLUS)) {
            return -1;
        }
        check = name.substring(0, name.length() - SCRIPT_PLUS.length());
        if (check.endsWith(SCRIPT_BY_COMET)) {
            return 1;
        }
        if (check.endsWith(SCRIPT_BY_JCOMET)) {
            return 1;
        }
        if (check.endsWith(SCRIPT_BY_AJAX)) {
            return 2;
        }
        if (check.endsWith(SCRIPT_BY_CONTROLLER)) {
            return 3;
        }
        if (check.endsWith(SCRIPT_BY_JSONP)) {
            return 4;
        }
        if (check.endsWith(SCRIPT_BY_TRIGGER)) {
            return 31;
        }
        if (check.endsWith(SCRIPT_BY_INNER)) {
            return 32;
        }
        if (check.endsWith(SCRIPT_BY_FILTER)) {
            return 98;
        }
        return -1;
    }

    public static final String getTypeByString(int type) {
        switch (type) {
            case -1: {
                return "etc";
            }
            case 1: {
                return MODE_COMET;
            }
            case 2: {
                return "ajax";
            }
            case 3: {
                return "controller";
            }
            case 4: {
                return "jsonp";
            }
            case 10: {
                return "html";
            }
            case 20: {
                return "model";
            }
            case 30: {
                return "lib";
            }
            case 31: {
                return "trigger";
            }
            case 32: {
                return "inner";
            }
            case 99: {
                return "etc";
            }
        }
        return "etc";
    }

    public static final boolean isScript(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return false;
        }
        return (name = name.toLowerCase()).endsWith(SCRIPT_PLUS) || name.endsWith(SCRIPT_HTML_PLUS);
    }

    public static final String convertApplicationName(String path, String name) throws Exception {
        if (path == null || (path = path.trim()).length() <= 0 || name == null || (name = name.trim()).length() <= 0) {
            throw new HttpdStateException(404, "\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (name.startsWith("/")) {
            return name;
        }
        if (name.startsWith("\\")) {
            return StringUtil.changeString((String)name, (String)"\\", (String)"/");
        }
        if (path.startsWith("\\") || path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = String.valueOf(path) + "/";
        }
        if (name.startsWith("\\") || name.startsWith("/")) {
            name = name.substring(1, name.length());
        }
        if (path.startsWith("\\") || path.startsWith("/")) {
            path = "." + path;
        }
        String fullPath = FileUtil.getFullPath((String)".");
        String params = "";
        int p = name.indexOf("?");
        if (p != -1) {
            params = name.substring(p);
            name = name.substring(0, p);
        }
        String file = FileUtil.getFileName((String)name);
        String target = FileUtil.getFullPath((String)(String.valueOf(path) + name));
        if (fullPath.length() > target.length()) {
            throw new HttpdStateException(404, "\u6307\u5b9a\u540d[" + name + "]\u306e\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059");
        }
        target = target.substring(fullPath.length(), target.length());
        fullPath = null;
        if (!target.endsWith(file)) {
            throw new HttpdStateException(404, "\u6307\u5b9a\u540d[" + name + "]\u306e\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return String.valueOf(StringUtil.changeString((String)target, (String)"\\", (String)"/")) + params;
    }

    public static String getScriptByResource(String path) throws Exception {
        return ScriptDef.getScriptByResource(path, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getScriptByResource(String path, String src, String dest) throws Exception {
        StringBuilder buf;
        BufferedReader br;
        block14: {
            String s;
            block13: {
                String s2;
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                br = null;
                buf = new StringBuilder();
                br = new BufferedReader(new InputStreamReader(cl.getResourceAsStream(path), "UTF8"));
                if (src == null || dest == null) break block13;
                while ((s2 = br.readLine()) != null) {
                    s2 = StringUtil.changeString((String)s2, (String)src, (String)dest);
                    buf.append(s2);
                    buf.append("\r\n");
                }
                break block14;
            }
            while ((s = br.readLine()) != null) {
                buf.append(s);
                buf.append("\r\n");
            }
        }
        br.close();
        br = null;
        return buf.toString();
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static final String getScriptManagerCode(String[] scripts, String currentDirectory) throws Exception {
        if (scripts != null && scripts.length > 0) {
            StringBuilder buf = new StringBuilder();
            int len = scripts.length;
            int i = 0;
            while (i < len) {
                if (i != 0) {
                    buf.append(":");
                }
                buf.append(scripts[i]);
                long time = FileUtil.getLastTime((String)(String.valueOf(currentDirectory) + scripts[i]));
                buf.append("-").append(time);
                ++i;
            }
            byte[] bin = buf.toString().getBytes("UTF8");
            buf = null;
            return Digest.convert((String)"SHA1", (byte[])bin);
        }
        return null;
    }

    public static final String[] getUseScript(String directory) {
        String[] names = FileUtil.getFileList((String)directory);
        if (names != null && names.length > 0) {
            int cnt = 0;
            int len = names.length;
            int i = 0;
            while (i < len) {
                if (names[i] != null && names[i].endsWith(SCRIPT_PLUS)) {
                    ++cnt;
                }
                ++i;
            }
            if (cnt > 0) {
                String[] ret = new String[cnt];
                cnt = 0;
                int i2 = 0;
                while (i2 < len) {
                    if (names[i2] != null && names[i2].endsWith(SCRIPT_PLUS)) {
                        ret[cnt] = names[i2].substring(0, names[i2].length() - SCRIPT_PLUS.length());
                        ++cnt;
                    }
                    ++i2;
                }
                return ret;
            }
        }
        return null;
    }

    public static final void setDirectoryByBindings(ScriptContext ctx) throws Exception {
        if (ctx == null) {
            return;
        }
        ScriptDef.setDirectoryByBindings(ctx.getBindings(100));
    }

    public static final void setDirectoryByBindings(Bindings bindings) throws Exception {
        if (bindings == null) {
            return;
        }
        String current = ScriptDef.trimCurrentDirectory(".");
        bindings.put("_$path$currentPath", (Object)current);
        bindings.put("_$path$scriptPath", (Object)(String.valueOf(current) + "application/"));
        bindings.put("_$path$modelPath", (Object)(String.valueOf(current) + "model/"));
    }

    public static final HashMap<String, Object> getQuery(HttpdParams params) {
        if (params == null) {
            return new HashMap<String, Object>();
        }
        return params.getPrivateMap();
    }
}

