/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script;

import java.util.HashMap;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.HttpdParams;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.script.BaseModel;
import org.maachang.comet.httpd.engine.script.BaseModelImpl;
import org.maachang.comet.httpd.engine.script.BaseScriptException;
import org.maachang.comet.httpd.engine.script.EndScript;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.WebAppScriptFactory;
import org.maachang.comet.httpd.engine.script.cache.CacheScriptManager;
import org.maachang.comet.httpd.engine.session.HttpdSession;
import org.maachang.manager.GlobalManager;
import org.maachang.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetScript {
    private static final Log LOG = LogFactory.getLog(TargetScript.class);
    private ScriptContext context = null;
    private Script script = null;
    private HttpdRequest request = null;
    private String path = null;
    private String accessName = null;
    private Object result = null;
    private long accessTime = -1L;

    private TargetScript() {
    }

    public TargetScript(String path, HttpdRequest request) throws Exception {
        Script script;
        if (request == null) {
            throw new HttpdStateException(400, "\u4e0d\u6b63\u306a\u30ea\u30af\u30a8\u30b9\u30c8\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f");
        }
        this.accessTime = System.currentTimeMillis();
        WebAppScriptFactory factory = TargetScript.getFactory();
        path = path.trim();
        String name = FileUtil.getFileName((String)path);
        path = path.substring(0, path.length() - name.length());
        if (name.indexOf(".") != -1 && name.endsWith(".ms")) {
            name = name.substring(0, name.length() - ".ms".length());
        }
        if ((script = factory.getApplication(String.valueOf(path) + name)) == null) {
            throw new HttpdStateException(500, "\u5bfe\u8c61\u30d1\u30b9[" + path + name + "]\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        this.context = null;
        this.script = script;
        this.request = request;
        this.path = path;
        this.accessName = String.valueOf(path) + name;
    }

    protected void finalize() throws Exception {
        this.accessTime = -1L;
        this.context = null;
        this.script = null;
        this.request = null;
        this.path = null;
        this.result = null;
        this.accessName = null;
    }

    public Object execution(HashMap<String, Object> params) throws Exception {
        Object ret;
        block26: {
            ret = null;
            BaseModelImpl baseModel = new BaseModelImpl();
            if (params == null) {
                params = new HashMap();
            }
            params.put("__$type$script", "script");
            try {
                try {
                    this.context = new SimpleScriptContext();
                    CacheScriptManager.getInstance().script(this.context);
                    this.createContext(this.context, baseModel);
                    ScriptDef.setDirectoryByBindings(this.context);
                    ret = this.script.getScript().execution(this.context, params);
                    if (baseModel.isCreate()) {
                        baseModel.commit();
                    }
                }
                catch (ScriptException sc) {
                    if (EndScript.isEndScript(sc)) {
                        ret = EndScript.getEndByResult(this.context);
                        if (baseModel.isCreate()) {
                            baseModel.commit();
                        }
                        break block26;
                    }
                    if (baseModel.isCreate()) {
                        try {
                            baseModel.rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw new BaseScriptException(sc);
                }
                catch (Exception e) {
                    if (baseModel.isCreate()) {
                        try {
                            baseModel.rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
            }
            finally {
                if (baseModel.isCreate()) {
                    try {
                        baseModel.getRecord().close();
                    }
                    catch (Exception exception) {}
                }
                try {
                    CacheScriptManager.getInstance().executionByExitRequest();
                }
                catch (Exception exception) {}
                baseModel = null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("... readScript:" + this.accessName + " - [" + (System.currentTimeMillis() - this.accessTime) + "ms]"));
                }
            }
        }
        this.result = ret;
        return ret;
    }

    public ScriptContext getScriptContext() {
        return this.context;
    }

    public HttpdSession getSession() throws Exception {
        return this.request.getSession();
    }

    public String getPath() {
        return this.path;
    }

    public Object getResult() {
        return this.result;
    }

    private void createContext(ScriptContext ctx, BaseModel baseModel) throws Exception {
        Bindings bindings = ctx.getBindings(100);
        bindings.put("_$script$base_model", (Object)baseModel);
        bindings.put("_$script$path", (Object)this.path);
        bindings.put("_$script$header", (Object)this.request.getHeader());
        HttpdSession session = this.request.getSession();
        if (session != null) {
            bindings.put("_$script$session", (Object)session);
        }
        TargetScript.pushRequestParams(bindings, this.request.getQuery());
    }

    private static final WebAppScriptFactory getFactory() {
        return (WebAppScriptFactory)GlobalManager.getValue((String)"WEBAPP_FACTORY");
    }

    private static final void pushRequestParams(Bindings bindings, HttpdParams params) {
        HashMap<String, Object> spms = ScriptDef.getQuery(params);
        bindings.put("_$script$query", (Object)spms);
    }
}

