/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cache;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.conf.IniFile;
import org.maachang.comet.httpd.engine.script.BaseModelImpl;
import org.maachang.comet.httpd.engine.script.cache.CacheScriptManager;
import org.maachang.comet.httpd.engine.script.cache.CacheTable;
import org.maachang.comet.httpd.engine.script.cache.CacheTableWrapper;
import org.maachang.manager.GlobalManager;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

public class StartupScript {
    private static final Log LOG = LogFactory.getLog(StartupScript.class);
    protected static final String ENGINE_NAME = "js";
    protected static final String CACHE_NAME = "startup";
    protected static final String DETAIL_NAME = "startup";
    protected static final String STARTUP_NAME = "Startup.ms";
    protected static final String SHUTDOWN_NAME = "Shutdown.ms";

    private StartupScript() {
    }

    public static void startup(IniFile ini, CacheTableWrapper wrapper) throws Exception {
        StartupScript.executionStartup(true, ini, wrapper);
    }

    public static void shutdown(IniFile ini, CacheTableWrapper wrapper) throws Exception {
        StartupScript.executionStartup(false, ini, wrapper);
    }

    private static final void executionStartup(boolean mode, IniFile ini, CacheTableWrapper wrapper) throws Exception {
        int len = ini.size("startup", "script");
        if (len <= 0) {
            return;
        }
        CacheScriptManager.getInstance().executionByExitRequest();
        CacheScriptManager.getInstance().reload();
        CacheTable cacheTable = wrapper.getCacheTable();
        cacheTable.waitByStartUpdate();
        try {
            try {
                ScriptEngine engine = StartupScript.getScriptEngine();
                wrapper.setCacheAppend(true);
                Bindings bindings = StartupScript.getBindings(wrapper);
                int i = 0;
                while (i < len) {
                    String scriptName = null;
                    scriptName = mode ? ini.get("startup", "script", i) : ini.get("startup", "script", len - (i + 1));
                    if (scriptName != null && (scriptName = scriptName.trim()).length() > 0) {
                        scriptName = mode ? String.valueOf(scriptName) + STARTUP_NAME : String.valueOf(scriptName) + SHUTDOWN_NAME;
                        LOG.info((Object)("## [" + StartupScript.getExecName(mode) + "] - (" + scriptName + ")\u3092\u5b9f\u884c - \u958b\u59cb"));
                        if (!StartupScript.executionScript(engine, bindings, scriptName)) {
                            LOG.warn((Object)("## [" + StartupScript.getExecName(mode) + "] - (" + scriptName + ")\u3092\u5b9f\u884c - [NG]"));
                        } else {
                            LOG.info((Object)("## [" + StartupScript.getExecName(mode) + "] - (" + scriptName + ")\u3092\u5b9f\u884c - [OK]"));
                        }
                    }
                    ++i;
                }
                bindings = cacheTable.getBindings();
                cacheTable.putParent("startup", bindings);
                LOG.info((Object)("## [" + StartupScript.getExecName(mode) + "] - \u6b63\u5e38\u7d42\u4e86"));
            }
            catch (Exception e) {
                LOG.info((Object)("## [" + StartupScript.getExecName(mode) + "] - \u7570\u5e38\u7d42\u4e86"), (Throwable)e);
                throw e;
            }
        }
        finally {
            wrapper.setCacheAppend(false);
            cacheTable.exitUpdate();
        }
    }

    private static final boolean executionScript(ScriptEngine engine, Bindings bindings, String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            return false;
        }
        if (name.startsWith("/") || name.startsWith("\\")) {
            name = name.substring(1);
        }
        name = StringUtil.changeString((String)name, (String)"\\", (String)"/");
        String file = FileUtil.getFullPath((String)("." + (name = "/startup/" + name)));
        if (!FileUtil.isFileExists((String)file) || !FileUtil.isRead((String)file)) {
            return false;
        }
        String script = FileUtil.getFileByString((String)file, (String)"UTF8");
        engine.put("javax.script.filename", name);
        BaseModelImpl baseModel = null;
        boolean errorFlag = false;
        try {
            try {
                baseModel = new BaseModelImpl();
                SimpleScriptContext ctx = new SimpleScriptContext();
                ctx.setBindings(bindings, 100);
                bindings.put("_$script$base_model", (Object)baseModel);
                bindings.put("_$script$context", (Object)ctx);
                bindings.put("_$script$engine", (Object)engine);
                engine.eval(script, bindings);
            }
            catch (Exception e) {
                errorFlag = true;
                throw e;
            }
        }
        finally {
            bindings.remove("_$script$base_model");
            if (baseModel != null && baseModel.isCreate()) {
                try {
                    if (errorFlag) {
                        baseModel.rollback();
                    } else {
                        baseModel.commit();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    private static final ScriptEngine getScriptEngine() {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(ENGINE_NAME);
        return engine;
    }

    private static final Bindings getBindings(CacheTableWrapper wrapper) throws Exception {
        SimpleBindings bindings = new SimpleBindings(wrapper);
        bindings.put("_$current$name", (Object)"startup");
        bindings.put("__$type$script", (Object)"script");
        bindings.put("__$detail$script", (Object)"startup");
        bindings.put("_$$maachang_comet_manager", (Object)GlobalManager.getInstance());
        bindings.put("log", (Object)LOG);
        return bindings;
    }

    private static final String getExecName(boolean mode) {
        return mode ? "startup" : "shutdown";
    }
}

