/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.image;

import org.maachang.util.ConvertParam;

public class ImageData {
    protected static final String[] IMAGE_MIME = new String[]{"", "image/jpeg", "image/gif", "image/x-png", "image/x-bmp", "application/x-shockwave-flash"};
    private int type = -1;
    private long lastTime = -1L;
    private byte[] image = null;

    public ImageData() {
    }

    public ImageData(int type, long lastTime, byte[] image) {
        this.type = type;
        this.lastTime = lastTime;
        this.image = image;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        this.type = -1;
        this.lastTime = -1L;
        this.image = null;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public String getMime() {
        if (this.type < 0 || this.type >= IMAGE_MIME.length) {
            return null;
        }
        return IMAGE_MIME[this.type];
    }

    public void setLastTime(long lastTime) {
        this.lastTime = lastTime;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public int getLength() {
        if (this.image == null) {
            return -1;
        }
        return this.image.length;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public byte[] getImage() {
        return this.image;
    }

    protected byte[] save() {
        return ImageData.save(this.type, this.lastTime, this.image);
    }

    protected static final byte[] save(int type, long lastTime, byte[] image) {
        byte[] ret = new byte[12 + image.length];
        int pnt = 0;
        ConvertParam.convertInt((byte[])ret, (int)pnt, (int)type);
        ConvertParam.convertLong((byte[])ret, (int)(pnt += 4), (long)lastTime);
        System.arraycopy(image, 0, ret, pnt += 8, image.length);
        return ret;
    }

    protected static final ImageData load(byte[] binary) throws Exception {
        ImageData ret = new ImageData();
        int pnt = 0;
        ret.type = ConvertParam.convertInt((int)pnt, (byte[])binary);
        ret.lastTime = ConvertParam.convertInt((int)(pnt += 4), (byte[])binary);
        int len = binary.length - (pnt += 8);
        ret.image = new byte[len];
        System.arraycopy(binary, pnt, ret.image, 0, len);
        return ret;
    }
}

