/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.service.mail;

import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.service.mail.MailAuth;
import org.maachang.comet.httpd.engine.script.service.mail.ResultAttached;
import org.maachang.comet.httpd.engine.script.service.mail.SendMail;

public class SendMailService {
    private static final Log LOG = LogFactory.getLog(SendMailService.class);
    private static final String CHARSET = "ISO-2022-JP";

    public static final boolean sendMailTo(SendMail sendMail) {
        try {
            SendMailService.sendMail(sendMail);
        }
        catch (Exception e) {
            LOG.error((Object)"sendMailError", (Throwable)e);
            return false;
        }
        return true;
    }

    public static final void sendMail(SendMail sendMail) throws Exception {
        if (sendMail == null || !sendMail.check()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", sendMail.getHost());
        if (sendMail.getPort() > 0) {
            props.put("mail.smtp.port", String.valueOf(sendMail.getPort()));
        }
        if (sendMail.getTimeout() > 0L) {
            props.setProperty("mail.smtp.connectiontimeout", String.valueOf(sendMail.getTimeout()));
            props.setProperty("mail.smtp.timeout", String.valueOf(sendMail.getTimeout()));
        }
        if (sendMail.isSsl()) {
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            if (sendMail.getPort() > 0) {
                props.setProperty("mail.smtp.socketFactory.port", String.valueOf(sendMail.getPort()));
            }
        }
        Session session = null;
        if (sendMail.isAuth()) {
            props.setProperty("mail.smtp.auth", "true");
            session = Session.getInstance((Properties)props, (Authenticator)new MailAuth(sendMail.getUser(), sendMail.getPasswd()));
        } else {
            session = Session.getInstance((Properties)props, null);
        }
        MimeMessage msg = new MimeMessage(session);
        msg.setHeader("Content-Type", "text/plain; charset=ISO-2022-JP");
        msg.setHeader("Content-Transfer-Encoding", "7bit");
        msg.setFrom((Address)new InternetAddress(sendMail.getFrom()));
        InternetAddress[] address = SendMailService.getTo(sendMail);
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        msg.setSubject(MimeUtility.encodeText((String)sendMail.getSubject(), (String)CHARSET, (String)"B"));
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setHeader("Content-Transfer-Encoding", "7bit");
        textPart.setText(sendMail.getBody(), CHARSET);
        multipart.addBodyPart((BodyPart)textPart);
        if (sendMail.getAttached() != null && sendMail.getAttached().size() > 0) {
            ArrayList<ResultAttached> lst = sendMail.getAttached();
            MimeBodyPart attachmentPart = new MimeBodyPart();
            int len = lst.size();
            int i = 0;
            while (i < len) {
                ResultAttached ra = lst.get(i);
                if (ra != null && ra.getAttached() != null && ra.getAttached().length > 0) {
                    ByteArrayDataSource ba = new ByteArrayDataSource(ra.getAttached(), "application/octet-stream");
                    attachmentPart.setDataHandler(new DataHandler((DataSource)ba));
                    if (ra.getFileName() != null && ra.getFileName().length() > 0) {
                        attachmentPart.setFileName(MimeUtility.encodeText((String)ra.getFileName(), (String)CHARSET, null));
                    }
                    multipart.addBodyPart((BodyPart)attachmentPart);
                }
                ++i;
            }
        }
        msg.setContent((Multipart)multipart);
        msg.setSentDate(new Date());
        Transport.send((Message)msg);
    }

    private static InternetAddress[] getTo(SendMail sendMail) throws Exception {
        int len = sendMail.getTo().size();
        InternetAddress[] ret = new InternetAddress[len];
        int i = 0;
        while (i < len) {
            ret[i] = new InternetAddress(sendMail.getTo().get(i));
            ++i;
        }
        return ret;
    }
}

