/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

class BinaryArray {
    private static final int BUFFER = 4096;
    private byte[] binary = new byte[4096];
    private int length = 0;
    private long lastAccessTime = System.currentTimeMillis();

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        this.binary = null;
        this.length = 0;
        this.lastAccessTime = -1L;
    }

    public synchronized void reset() {
        if (this.binary.length == 4096) {
            this.length = 0;
        } else {
            this.binary = new byte[4096];
            this.length = 0;
        }
        this.lastAccessTime = -1L;
    }

    public synchronized void write(int b) throws Exception {
        if (this.binary.length <= this.length) {
            byte[] t = this.binary;
            int iLen = t.length * 2;
            this.binary = new byte[iLen];
            System.arraycopy(t, 0, this.binary, 0, t.length);
            byte[] byArray = null;
        }
        this.binary[this.length] = (byte)(b & 0xFF);
        ++this.length;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public synchronized int getByte(int no) {
        if (no <= -1 || no >= this.length) {
            return -1;
        }
        return this.binary[no] & 0xFF;
    }

    public synchronized byte[] getBinary() {
        return this.binary;
    }

    public synchronized byte[] getBinary(int length) {
        if (length <= 0) {
            length = this.length;
        }
        if (this.length < length) {
            length = this.length;
        }
        byte[] ret = new byte[length];
        System.arraycopy(this.binary, 0, ret, 0, length);
        return ret;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized long getUpdateTime() {
        return this.lastAccessTime;
    }
}

