/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.io.IOException;
import java.io.OutputStream;

class ChunkedOutputStream
extends OutputStream {
    private static final int DEFAULT_BUF = 32768;
    private static final int DEFAULT_MIN = 512;
    private static final int DEFAULT_MAX = 65535;
    private static final String CHARSET = "US-ASCII";
    private static final byte[] ENTER = new byte[]{13, 10};
    private static final byte[] ENDCHUNK = ENTER;
    private static final byte[] ZERO = new byte[]{48};
    private static final String ENTER_STR = "\r\n";
    private OutputStream stream = null;
    private byte[] cache;
    private int cachePosition = 0;
    private boolean wroteLastChunk = false;

    public ChunkedOutputStream(OutputStream stream, int bufferSize) throws IOException {
        if (bufferSize <= 512) {
            bufferSize = 512;
        } else if (bufferSize >= 65535) {
            bufferSize = 65535;
        }
        this.cache = new byte[bufferSize];
        this.stream = stream;
    }

    public ChunkedOutputStream(OutputStream stream) throws IOException {
        this(stream, 32768);
    }

    protected void flushCache() throws IOException {
        if (this.cachePosition > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(Integer.toHexString(this.cachePosition));
            buf.append(ENTER_STR);
            byte[] chunkHeader = buf.toString().getBytes(CHARSET);
            buf = null;
            this.stream.write(chunkHeader, 0, chunkHeader.length);
            this.stream.write(this.cache, 0, this.cachePosition);
            this.stream.write(ENDCHUNK, 0, ENDCHUNK.length);
            this.cachePosition = 0;
        }
    }

    protected void writeClosingChunk() throws IOException {
        this.stream.write(ZERO, 0, ZERO.length);
        this.stream.write(ENTER, 0, ENTER.length);
        this.stream.write(ENDCHUNK, 0, ENDCHUNK.length);
    }

    public void finish() throws IOException {
        if (!this.wroteLastChunk) {
            this.flushCache();
            this.writeClosingChunk();
            this.wroteLastChunk = true;
        }
    }

    public void write(int b) throws IOException {
        this.cache[this.cachePosition] = (byte)b;
        ++this.cachePosition;
        if (this.cachePosition == this.cache.length) {
            this.flushCache();
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] src, int off, int len) throws IOException {
        if (len >= this.cache.length - this.cachePosition) {
            this.flushCacheWithAppend(src, off, len);
        } else {
            System.arraycopy(src, off, this.cache, this.cachePosition, len);
            this.cachePosition += len;
        }
    }

    protected void flushCacheWithAppend(byte[] bufferToAppend, int off, int len) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(Integer.toHexString(this.cachePosition + len));
        buf.append(ENTER_STR);
        byte[] chunkHeader = buf.toString().getBytes(CHARSET);
        buf = null;
        this.stream.write(chunkHeader, 0, chunkHeader.length);
        this.stream.write(this.cache, 0, this.cachePosition);
        this.stream.write(bufferToAppend, off, len);
        this.stream.write(ENDCHUNK, 0, ENDCHUNK.length);
        this.cachePosition = 0;
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void close() throws IOException {
        this.finish();
        super.close();
    }
}

