/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.io.BufferedInputStream;
import java.nio.channels.CancelledKeyException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.HttpConnectionInfo;
import org.maachang.comet.httpd.HttpSocket;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.net.HttpCallbackReceive;
import org.maachang.comet.net.HttpInputStream;
import org.maachang.comet.net.HttpUseQueue;
import org.maachang.comet.net.ReadHttpdRequest;
import org.maachang.util.SequenceSync;

class NetPoolThread
extends Thread {
    private static final Log LOG = LogFactory.getLog(NetPoolThread.class);
    private HttpUseQueue queue = null;
    private HttpCallbackReceive receive = null;
    private SequenceSync sequence = null;
    private volatile boolean stopFlag = true;
    private static final long WAIT_TIME = 30L;

    private NetPoolThread() {
    }

    public NetPoolThread(HttpUseQueue queue, HttpCallbackReceive receive, SequenceSync sequence) throws Exception {
        this.queue = queue;
        this.receive = receive;
        this.sequence = sequence;
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ThreadDeath threadDeach = null;
        boolean errorFlag = false;
        boolean endFlag = false;
        while (true) {
            errorFlag = false;
            HttpSocket conn = null;
            try {
                try {
                    if (endFlag || this.isStop()) break;
                    conn = this.queue.getQueue();
                    if (conn != null) {
                        HttpConnectionInfo info = conn.getConnectionInfo();
                        if (info == null || !info.isUse()) continue;
                        int seqId = this.sequence.getId();
                        long executionTime = System.currentTimeMillis();
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("receive(" + seqId + ") - [" + info.getSocket().socket().getInetAddress().getHostAddress() + ":" + info.getSocket().socket().getPort() + "]"));
                        }
                        this.receive.execution(info, seqId, NetPoolThread.readHttpdRequest(conn, seqId));
                        long receiveEndTime = conn.getReceiveStartTimeToNow();
                        conn.endReceive();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("receiveTime(" + seqId + ") - [" + info.getSocket().socket().getInetAddress().getHostAddress() + ":" + info.getSocket().socket().getPort() + "]... " + (System.currentTimeMillis() - executionTime) + "ms (all:" + receiveEndTime + ")" + "ms"));
                        }
                        if (conn.isCloseFlag()) {
                            conn.destroy();
                            continue;
                        }
                        boolean isCloseFlag = false;
                        try {
                            if (!info.isUse()) {
                                isCloseFlag = true;
                            }
                        }
                        catch (Exception ex) {
                            isCloseFlag = true;
                        }
                        if (!isCloseFlag) {
                            info.update();
                            if (info.getCount() > 0) {
                                if (info.getTimeout() > 0L) {
                                    info.recyclingConnection();
                                }
                            } else {
                                isCloseFlag = true;
                            }
                        }
                        if (!isCloseFlag) continue;
                        conn.destroy();
                        continue;
                    }
                    NetPoolThread.sleep(30L);
                }
                finally {
                    if (!errorFlag || conn == null) continue;
                    conn.destroy();
                }
            }
            catch (InterruptedException ie) {
                errorFlag = true;
                endFlag = true;
            }
            catch (CancelledKeyException ck) {
                errorFlag = true;
                LOG.warn((Object)"## cancell - key");
            }
            catch (OutOfMemoryError mem) {
                errorFlag = true;
                LOG.error((Object)"## out-of-memory-error", (Throwable)mem);
            }
            catch (Exception e) {
                errorFlag = true;
                LOG.error((Object)"## error", (Throwable)e);
            }
            catch (ThreadDeath td) {
                errorFlag = true;
                endFlag = true;
                threadDeach = td;
            }
        }
        this.queue = null;
        this.receive = null;
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }

    private static final HttpdRequest readHttpdRequest(HttpSocket socket, int seqId) throws Exception {
        if (socket == null || socket.isClosed()) {
            return null;
        }
        BufferedInputStream buf = null;
        try {
            buf = new BufferedInputStream(new HttpInputStream(socket.inputStream()));
            HttpdRequest ret = ReadHttpdRequest.receiveHttpRequest(buf, seqId);
            buf.close();
            buf = null;
            socket.update();
            HttpdRequest httpdRequest = ret;
            return httpdRequest;
        }
        finally {
            if (buf != null) {
                try {
                    buf.close();
                }
                catch (Exception exception) {}
                buf = null;
            }
        }
    }
}

