/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.dao.dbms.MetaColumn;
import org.maachang.dao.dbms.Record;
import org.maachang.dao.dbms.kind.SupportKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseRecord
implements Record {
    private static final Log LOG = LogFactory.getLog(BaseRecord.class);
    private SupportKind kind = null;
    private boolean supportBoolean = false;
    private Connection connection = null;
    private boolean commitRollbackFlag = true;
    private boolean sequence = false;
    private Statement statement = null;
    private HashMap<String, PreparedStatement> pman = null;
    private boolean debug = false;

    private BaseRecord() {
    }

    public BaseRecord(SupportKind kind, boolean debug, Connection connection) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.kind = kind;
        this.debug = debug;
        this.supportBoolean = kind.isBoolean();
        this.sequence = kind.getSequenceId(null) != null;
        this.connection = connection;
    }

    protected void finalize() throws Exception {
        this.close();
    }

    @Override
    public void close() {
        if (!this.commitRollbackFlag && this.connection != null) {
            try {
                this.connection.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.clearStatements();
        this.commitRollbackFlag = true;
        this.connection = null;
        this.statement = null;
        this.pman = null;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean commit() throws Exception {
        if (this.connection != null) {
            if (this.debug && LOG.isDebugEnabled()) {
                LOG.debug((Object)"# sql:commit");
            }
            if (!this.commitRollbackFlag) {
                this.connection.commit();
                this.commitRollbackFlag = true;
                this.clearStatements();
                return true;
            }
            this.connection.rollback();
            this.commitRollbackFlag = true;
            this.clearStatements();
            return false;
        }
        this.clearStatements();
        return false;
    }

    @Override
    public boolean rollback() throws Exception {
        if (this.connection != null) {
            if (this.debug && LOG.isDebugEnabled()) {
                LOG.debug((Object)"# sql:rollback");
            }
            this.connection.rollback();
            this.commitRollbackFlag = true;
            this.clearStatements();
            return true;
        }
        this.clearStatements();
        return false;
    }

    @Override
    public synchronized void clearStatements() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.statement = null;
        }
        if (this.pman != null) {
            Object[] objs = this.pman.keySet().toArray();
            if (objs != null && objs.length > 0) {
                int len = objs.length;
                int i = 0;
                while (i < len) {
                    PreparedStatement ps = this.pman.get((String)objs[i]);
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ps = null;
                    ++i;
                }
            }
            this.pman.clear();
        }
    }

    @Override
    public MetaColumn getMetaColumn(String table) throws Exception {
        ResultSet r = null;
        try {
            r = this.getStatement().executeQuery("select * from " + table);
            ResultSetMetaData meta = r.getMetaData();
            MetaColumn ret = new MetaColumn(table, meta);
            r.close();
            r = null;
            MetaColumn metaColumn = ret;
            return metaColumn;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
            r = null;
        }
    }

    @Override
    public boolean isUse() {
        boolean ret = false;
        try {
            ret = this.connection != null && !this.connection.isClosed();
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    @Override
    public ResultSet executeQuery(String sql) throws Exception {
        if (this.connection == null) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql));
        }
        long time = System.currentTimeMillis();
        ResultSet ret = this.getStatement().executeQuery(sql);
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql + "[" + (System.currentTimeMillis() - time) + "ms]"));
        }
        this.commitRollbackFlag = false;
        return ret;
    }

    @Override
    public int executeUpdate(String sql) throws Exception {
        if (this.connection == null) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql));
        }
        long time = System.currentTimeMillis();
        int ret = this.getStatement().executeUpdate(sql);
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql + "[" + (System.currentTimeMillis() - time) + "ms]"));
        }
        this.commitRollbackFlag = false;
        return ret;
    }

    private synchronized Statement getStatement() throws Exception {
        if (this.statement == null) {
            this.statement = this.connection.createStatement();
        }
        return this.statement;
    }

    @Override
    public ResultSet executeQuery(String sql, ArrayList<Object> params) throws Exception {
        Object[] o = null;
        if (params != null && params.size() > 0) {
            int len = params.size();
            o = new Object[len];
            int i = 0;
            while (i < len) {
                o[i] = params.get(i);
                ++i;
            }
        }
        return this.executeQuery(sql, o);
    }

    @Override
    public ResultSet executeQuery(String sql, Object[] params) throws Exception {
        if (this.connection == null) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (sql == null || (sql = sql.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql));
        }
        long time = System.currentTimeMillis();
        PreparedStatement pre = this.getPreparedStatement(true, sql);
        BaseRecord.putParams(this.supportBoolean, pre, params);
        ResultSet ret = pre.executeQuery();
        this.commitRollbackFlag = false;
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql + "[" + (System.currentTimeMillis() - time) + "ms]"));
        }
        return ret;
    }

    @Override
    public int executeUpdate(String sql, ArrayList<Object> params) throws Exception {
        Object[] o = null;
        if (params != null && params.size() > 0) {
            int len = params.size();
            o = new Object[len];
            int i = 0;
            while (i < len) {
                o[i] = params.get(i);
                ++i;
            }
        }
        return this.executeUpdate(sql, o);
    }

    @Override
    public int executeUpdate(String sql, Object[] params) throws Exception {
        if (this.connection == null) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (sql == null || (sql = sql.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql));
        }
        long time = System.currentTimeMillis();
        PreparedStatement pre = this.getPreparedStatement(false, sql);
        BaseRecord.putParams(this.supportBoolean, pre, params);
        int ret = pre.executeUpdate();
        this.commitRollbackFlag = false;
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql + "[" + (System.currentTimeMillis() - time) + "ms]"));
        }
        return ret;
    }

    private synchronized PreparedStatement getPreparedStatement(boolean readOnly, String sql) throws Exception {
        PreparedStatement ret;
        if (sql == null || (sql = sql.trim()).length() <= 0 || this.connection == null) {
            return null;
        }
        if (this.pman == null) {
            this.pman = new HashMap();
        }
        if ((ret = this.pman.get(sql)) != null) {
            return ret;
        }
        ret = readOnly ? this.connection.prepareStatement(sql, 1004, 1007) : this.connection.prepareStatement(sql);
        ret = this.connection.prepareStatement(sql);
        this.pman.put(sql, ret);
        return ret;
    }

    @Override
    public SupportKind getSupportKind() {
        return this.kind;
    }

    @Override
    public boolean isSequence() {
        return this.sequence;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    private static final void putParams(boolean supportBoolean, PreparedStatement pre, Object[] params) throws Exception {
        if (params != null && params.length > 0) {
            int len = params.length;
            int i = 0;
            while (i < len) {
                BaseRecord.putOneParam(supportBoolean, i, pre, params[i]);
                ++i;
            }
        }
    }

    private static final void putOneParam(boolean supportBoolean, int no, PreparedStatement pre, Object one) throws Exception {
        if (one == null) {
            pre.setObject(no + 1, null);
        } else if (one instanceof Boolean) {
            boolean b = (Boolean)one;
            if (!supportBoolean) {
                if (b) {
                    pre.setString(no + 1, "1");
                } else {
                    pre.setString(no + 1, "0");
                }
            } else {
                pre.setBoolean(no + 1, b);
            }
        } else if (one instanceof String) {
            pre.setString(no + 1, (String)one);
        } else if (one instanceof Integer) {
            pre.setInt(no + 1, (Integer)one);
        } else if (one instanceof Long) {
            pre.setLong(no + 1, (Long)one);
        } else if (one instanceof Float) {
            pre.setFloat(no + 1, ((Float)one).floatValue());
        } else if (one instanceof Double) {
            pre.setDouble(no + 1, (Double)one);
        } else if (one instanceof java.util.Date) {
            if (one instanceof Timestamp) {
                pre.setTimestamp(no + 1, (Timestamp)one);
            } else if (one instanceof Time) {
                pre.setTime(no + 1, (Time)one);
            } else if (one instanceof Date) {
                pre.setDate(no + 1, (Date)one);
            } else {
                pre.setTimestamp(no + 1, new Timestamp(((java.util.Date)one).getTime()));
            }
        } else if (one instanceof byte[]) {
            pre.setBlob(no + 1, new ByteArrayInputStream((byte[])one));
        } else {
            throw new IllegalArgumentException("\u6307\u5b9a\u30d1\u30e9\u30e1\u30fc\u30bf[" + (no + 1) + "]\u306e\u6761\u4ef6\u306f\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093:" + one.getClass().getName());
        }
    }
}

