/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.io.IOException;
import java.io.OutputStream;

public class DebugOutputStream
extends OutputStream {
    private static final String CHARSET = "UTF8";
    private OutputStream outputStream = null;

    private DebugOutputStream() {
    }

    public DebugOutputStream(OutputStream outputStream) throws Exception {
        if (outputStream == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.outputStream = outputStream;
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public void close() throws IOException {
        this.flush();
        this.outputStream.close();
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void write(int b) throws IOException {
        System.out.println("###[stream]:" + new String(new byte[]{(byte)b}, CHARSET));
        this.outputStream.write(b);
    }

    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        System.out.println("###[stream]:" + new String(b, off, len, CHARSET));
        this.outputStream.write(b, off, len);
    }
}

