/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import org.maachang.dbm.engine.FlagMapFile;
import org.maachang.dbm.engine.MHash;
import org.maachang.dbm.engine.MKeyChild;
import org.maachang.dbm.engine.NextKey;
import org.maachang.dbm.engine.RandIO;
import org.maachang.util.FileUtil;

public class MKey {
    protected static final int MAX_KEY_LENGTH = 256;
    protected static final int KEY_HEADER_LENGTH = 31;
    protected static final int KEY_LENGTH = 287;
    protected static final int MAX_LENGTH = 15000000;
    protected static final int MAX_VALUE_FILE_SIZE = 1024;
    private static final int OFFSET = 1875012;
    private static final int DEFAULT_SIZE = 64;
    private static final int HASH_MASK = 1048575;
    private MHash hashMan = null;
    private RandIO fp = null;
    private FlagMapFile space = null;
    private final Object sync = new Object();

    private MKey() {
    }

    public MKey(MHash hashMan, String filename) throws Exception {
        if (hashMan == null || !hashMan.isUse() || filename == null || (filename = filename.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        filename = FileUtil.getFullPath(filename);
        boolean isFile = FileUtil.isFileExists(filename);
        RandIO fp = null;
        fp = !isFile ? new RandIO(287, 1893380L, filename) : new RandIO(287, filename);
        this.space = MKey.initSpace(isFile, fp);
        this.hashMan = hashMan;
        this.fp = fp;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.sync;
        synchronized (object) {
            if (this.hashMan != null) {
                this.hashMan.destroy();
            }
            if (this.space != null) {
                this.space.clear();
            }
            if (this.fp != null) {
                this.fp.destroy();
            }
            this.hashMan = null;
            this.fp = null;
            this.space = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws Exception {
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.hashMan.flush();
            this.space.flush();
        }
    }

    private static final FlagMapFile initSpace(boolean isFile, RandIO fp) throws Exception {
        return new FlagMapFile(!isFile, fp.getRandomAccessFile(), 0, 15000000);
    }

    private static final int nowMaxLength(RandIO fp) throws Exception {
        return ((int)(fp.getLength() & 0xFFFFFFFFL) - 1875012) / 287;
    }

    private final void expansion() throws Exception {
        int now = MKey.nowMaxLength(this.fp);
        if (now <= this.space.size()) {
            if (now >= 15000000) {
                throw new IOException("\u683c\u7d0d\u6570\u306f\u6700\u5927\u4ef6\u6570(15000000)\u3092\u8d8a\u3057\u3066\u3044\u308b\u305f\u3081\u3001\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093");
            }
            int addSpace = now;
            if (addSpace + now >= 15000000) {
                addSpace = 15000000 - now;
            }
            this.fp.expansion(addSpace * 287);
        }
    }

    protected boolean putCheck(int length) throws Exception {
        if (length <= 0) {
            return false;
        }
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.size() + length < 15000000;
    }

    public int[] put(int code, byte[] key, int fileNo, int filePos, int lastFileNo, int lastFilePos, int valueLength) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.expansion();
        MKeyChild ch = this.getMKeyChild(true, code, key);
        if (ch == null || !this.equalsKey(code, key, ch)) {
            this.addByChild(code, ch, key, fileNo, filePos, lastFileNo, lastFilePos, valueLength);
            return null;
        }
        int befFileNo = ch.getValueFileNo();
        int befFilePos = ch.getValueFilePos();
        ch.setValueFileNo(fileNo);
        ch.setValueFilePos(filePos);
        this.saveByChild(ch.getPosition(), ch);
        return new int[]{befFileNo, befFilePos};
    }

    public int[] remove(int code, byte[] key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        MKeyChild ch = this.getMKeyChild(false, code, key);
        if (ch == null) {
            return null;
        }
        this.removeByChild(code, ch);
        return new int[]{ch.getValueFileNo(), ch.getValueFilePos()};
    }

    public int[] get(int code, byte[] key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        MKeyChild ch = this.getMKeyChild(false, code, key);
        if (ch == null) {
            return null;
        }
        return new int[]{ch.getValueFileNo(), ch.getValueFilePos(), ch.getLastValueFileNo(), ch.getLastValueFilePos(), ch.getValueLength()};
    }

    public MKeyChild getChild(int code, byte[] key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.getMKeyChild(false, code, key);
    }

    public void saveChild(MKeyChild child) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (child == null || child.getPosition() <= -1) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.saveByChild(child.getPosition(), child);
    }

    private MKeyChild getMKeyChild(boolean mode, int code, byte[] key) throws Exception {
        MKeyChild ch;
        block3: {
            block2: {
                ch = null;
                if (!mode) break block2;
                MKeyChild bef = null;
                while ((ch = this.nextChild(bef, code)) != null && !this.equalsKey(code, key, ch)) {
                    bef = ch;
                }
                if (ch != null) break block3;
                ch = bef;
                break block3;
            }
            while ((ch = this.nextChild(ch, code)) != null && !this.equalsKey(code, key, ch)) {
            }
        }
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextKey nextKey(NextKey next) throws Exception {
        Object object = this.sync;
        synchronized (object) {
            int nextPos;
            if (!this.check()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            if (next == null) {
                next = new NextKey();
            }
            if ((nextPos = this.space.useNextPos(next.getPos())) <= -1) {
                next = null;
            } else {
                MKeyChild ch = this.posByChild(nextPos);
                if (ch == null) {
                    next = null;
                } else {
                    next = new NextKey();
                    next.setKey(ch.getKey());
                    next.setPos(nextPos);
                }
            }
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileName() {
        String ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = !this.check() ? null : this.fp.getName();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int ret = 0;
        Object object = this.sync;
        synchronized (object) {
            ret = !this.check() ? -1 : this.space.size();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUse() {
        boolean ret = false;
        Object object = this.sync;
        synchronized (object) {
            ret = this.check();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MHash getMHash() {
        MHash ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = this.hashMan;
        }
        return ret;
    }

    private boolean check() {
        return this.hashMan != null && this.hashMan.isUse() && this.fp != null && this.space != null;
    }

    private static final int getPosByAddress(int pos) {
        return 1875012 + pos * 287;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MKeyChild posByChild(int pos) throws Exception {
        if (pos <= -1 || pos >= 0x100000) {
            return null;
        }
        Object object = this.sync;
        synchronized (object) {
            if (!this.space.getPos(pos)) {
                return null;
            }
        }
        byte[] b = new byte[287];
        long addr = MKey.getPosByAddress(pos);
        Object object2 = this.sync;
        synchronized (object2) {
            this.fp.read(b, addr);
        }
        MKeyChild ret = MKeyChild.load(b);
        ret.setPosition(pos);
        return ret;
    }

    private final MKeyChild firstChild(int code) throws Exception {
        int p = this.hashMan.get(code & 0xFFFFF);
        if (p <= -1) {
            return null;
        }
        MKeyChild ret = this.posByChild(p);
        if (ret == null) {
            return null;
        }
        if (!ret.isUseKey()) {
            throw new IOException("\u4e0d\u6b63\u306aHash\u69cb\u6210\u304c\u5b58\u5728\u3057\u307e\u3059([firstChild],pos:" + p + "/" + MKey.getPosByAddress(p) + ")");
        }
        return ret;
    }

    private final MKeyChild nextChild(MKeyChild ch, int code) throws Exception {
        if (ch == null || !ch.isUseKey()) {
            return this.firstChild(code);
        }
        int p = ch.getNextHashPos();
        if (p <= -1) {
            return null;
        }
        MKeyChild ret = this.posByChild(p);
        if (ret == null) {
            return null;
        }
        if (!ret.isUseKey() || ret.getNextHashPos() == p) {
            int type = !ret.isUseKey() ? 1 : 2;
            throw new IOException("\u4e0d\u6b63\u306aHash\u69cb\u6210\u304c\u5b58\u5728\u3057\u307e\u3059([nextChild],pos:" + p + "/" + MKey.getPosByAddress(p) + " type:" + type + ")");
        }
        return ret;
    }

    private final boolean equalsKey(int code, byte[] key, MKeyChild ch) throws Exception {
        if (ch == null) {
            return false;
        }
        int len = key.length;
        if (code == ch.getHashCode() && len == ch.getKeyLength()) {
            byte[] dest = ch.getKey();
            int i = 0;
            while (i < len) {
                if (key[i] != dest[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveByChild(int pos, MKeyChild ch) throws Exception {
        if (ch == null) {
            throw new IOException("\u4e0d\u6b63\u306a\u8981\u7d20[" + MKey.getPosByAddress(pos) + "]\u4fdd\u5b58\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        byte[] b = ch.save();
        long addr = MKey.getPosByAddress(pos);
        Object object = this.sync;
        synchronized (object) {
            this.fp.write(b, addr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeByChild(int code, MKeyChild ch) throws Exception {
        Object object = this.sync;
        synchronized (object) {
            Integer hashCodePos = null;
            MKeyChild nextChild = this.posByChild(ch.getNextHashPos());
            MKeyChild beforeChild = this.posByChild(ch.getBeforeHashPos());
            if (nextChild != null || beforeChild != null) {
                if (nextChild != null) {
                    if (beforeChild == null) {
                        nextChild.setBeforeHashPos(-1);
                        hashCodePos = new Integer(nextChild.getPosition());
                    } else {
                        nextChild.setBeforeHashPos(beforeChild.getPosition());
                    }
                }
                if (beforeChild != null) {
                    if (nextChild == null) {
                        beforeChild.setNextHashPos(-1);
                    } else {
                        beforeChild.setNextHashPos(nextChild.getPosition());
                    }
                }
            } else {
                hashCodePos = new Integer(-1);
            }
            ch.setUseKey(false);
            this.saveByChild(ch.getPosition(), ch);
            if (nextChild != null) {
                this.saveByChild(nextChild.getPosition(), nextChild);
            }
            if (beforeChild != null) {
                this.saveByChild(beforeChild.getPosition(), beforeChild);
            }
            if (hashCodePos != null) {
                if (hashCodePos == -1) {
                    this.hashMan.remove(code & 0xFFFFF);
                } else {
                    this.hashMan.put(code & 0xFFFFF, hashCodePos);
                }
            }
            this.space.removePos(ch.getPosition());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addByChild(int code, MKeyChild ch, byte[] key, int fileNo, int filePos, int lastFileNo, int lastFilePos, int valueLength) throws Exception {
        MKeyChild newChild = new MKeyChild(code, -1, -1, fileNo, filePos, lastFileNo, lastFilePos, valueLength, key);
        Object object = this.sync;
        synchronized (object) {
            int usePos = this.space.usePos(0);
            if (usePos <= -1) {
                throw new IOException("\u7a7a\u304d\u6761\u4ef6\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            newChild.setPosition(usePos);
            if (ch != null) {
                ch.setNextHashPos(usePos);
                newChild.setBeforeHashPos(ch.getPosition());
                this.saveByChild(ch.getPosition(), ch);
            } else {
                this.hashMan.put(code & 0xFFFFF, newChild.getPosition());
            }
            this.saveByChild(newChild.getPosition(), newChild);
            this.space.setPos(usePos);
        }
    }
}

