/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.service.client;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import org.maachang.dbm.service.client.ClientSession;
import org.maachang.dbm.service.client.ResultClientQueue;
import org.maachang.util.ConvertParam;

class MDbmClientConnection {
    private static final String NOT_ACCESS = "\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u63a5\u7d9a\u304c\u78ba\u7acb\u3057\u3066\u3044\u307e\u305b\u3093";
    private static final long TIMEOUT = 15000L;
    private ClientSession session = null;

    private MDbmClientConnection() {
    }

    public MDbmClientConnection(Object sync, InetAddress addr, int port) throws Exception {
        this.session = new ClientSession(sync, addr, port);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        OutputStream output;
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream outputStream = output = this.session.output();
        synchronized (outputStream) {
            output.write(ConvertParam.convertInt(8));
            output.write(ConvertParam.convertInt(1));
            output.flush();
        }
        if (this.session != null) {
            this.session.destroy();
        }
    }

    public ClientSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws Exception {
        OutputStream output;
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream outputStream = output = this.session.output();
        synchronized (outputStream) {
            output.write(ConvertParam.convertInt(8));
            output.write(ConvertParam.convertInt(2));
            output.flush();
            byte[] bin = this.receive();
            if (MDbmClientConnection.resultType(bin) != 1) {
                throw new IOException("[commit]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws Exception {
        OutputStream output;
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream outputStream = output = this.session.output();
        synchronized (outputStream) {
            output.write(ConvertParam.convertInt(8));
            output.write(ConvertParam.convertInt(3));
            output.flush();
            byte[] bin = this.receive();
            if (MDbmClientConnection.resultType(bin) != 1) {
                throw new IOException("[rollback]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws Exception {
        OutputStream output;
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream outputStream = output = this.session.output();
        synchronized (outputStream) {
            output.write(ConvertParam.convertInt(8));
            output.write(ConvertParam.convertInt(4));
            output.flush();
            byte[] bin = this.receive();
            if (MDbmClientConnection.resultType(bin) != 1) {
                throw new IOException("[check]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte[] key, byte[] value) throws Exception {
        OutputStream output;
        if (key == null || key.length <= 0 || key.length > 256) {
            if (key == null || key.length <= 0) {
                throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u6700\u5927\u9577[256\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        if (value == null || value.length <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u8981\u7d20\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream outputStream = output = this.session.output();
        synchronized (outputStream) {
            output.write(ConvertParam.convertInt(16 + key.length + value.length));
            output.write(ConvertParam.convertInt(17));
            output.write(ConvertParam.convertInt(key.length));
            output.write(key);
            output.write(ConvertParam.convertInt(value.length));
            output.write(value);
            output.flush();
            byte[] bin = this.receive();
            if (MDbmClientConnection.resultType(bin) != 1) {
                throw new IOException("[put]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(byte[] key) throws Exception {
        OutputStream output;
        if (key == null || key.length <= 0 || key.length > 256) {
            if (key == null || key.length <= 0) {
                throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u6700\u5927\u9577[256\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream outputStream = output = this.session.output();
        synchronized (outputStream) {
            output.write(ConvertParam.convertInt(12 + key.length));
            output.write(ConvertParam.convertInt(18));
            output.write(ConvertParam.convertInt(key.length));
            output.write(key);
            output.flush();
            byte[] bin = this.receive();
            if (MDbmClientConnection.resultType(bin) != 1) {
                throw new IOException("[remove]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(byte[] key) throws Exception {
        OutputStream output;
        if (key == null || key.length <= 0 || key.length > 256) {
            if (key == null || key.length <= 0) {
                throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u6700\u5927\u9577[256\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream outputStream = output = this.session.output();
        synchronized (outputStream) {
            output.write(ConvertParam.convertInt(12 + key.length));
            output.write(ConvertParam.convertInt(19));
            output.write(ConvertParam.convertInt(key.length));
            output.write(key);
            output.flush();
            byte[] bin = this.receive();
            if (MDbmClientConnection.resultType(bin) != 17) {
                throw new IOException("[get]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
            }
            return MDbmClientConnection.dataResult(bin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(byte[] key) throws Exception {
        OutputStream output;
        if (key == null || key.length <= 0 || key.length > 256) {
            if (key == null || key.length <= 0) {
                throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new IllegalArgumentException("\u6307\u5b9a\u30ad\u30fc\u306f\u6700\u5927\u9577[256\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream outputStream = output = this.session.output();
        synchronized (outputStream) {
            output.write(ConvertParam.convertInt(12 + key.length));
            output.write(ConvertParam.convertInt(20));
            output.write(ConvertParam.convertInt(key.length));
            output.write(key);
            output.flush();
            byte[] bin = this.receive();
            if (MDbmClientConnection.resultType(bin) != 16) {
                throw new IOException("[containsKey]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
            }
            return MDbmClientConnection.booleanResult(bin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() throws Exception {
        OutputStream output;
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream outputStream = output = this.session.output();
        synchronized (outputStream) {
            output.write(ConvertParam.convertInt(8));
            output.write(ConvertParam.convertInt(257));
            output.flush();
            byte[] bin = this.receive();
            if (MDbmClientConnection.resultType(bin) != 18) {
                throw new IOException("[size]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
            }
            return MDbmClientConnection.sizeResult(bin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDirectory() throws Exception {
        OutputStream output;
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream outputStream = output = this.session.output();
        synchronized (outputStream) {
            output.write(ConvertParam.convertInt(8));
            output.write(ConvertParam.convertInt(258));
            output.flush();
            byte[] bin = this.receive();
            if (MDbmClientConnection.resultType(bin) != 17) {
                throw new IOException("[getDirectory]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
            }
            byte[] res = MDbmClientConnection.dataResult(bin);
            if (res == null) {
                return null;
            }
            return new String(res, "UTF8");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initKey() throws Exception {
        OutputStream output;
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream outputStream = output = this.session.output();
        synchronized (outputStream) {
            output.write(ConvertParam.convertInt(8));
            output.write(ConvertParam.convertInt(259));
            output.flush();
            byte[] bin = this.receive();
            if (MDbmClientConnection.resultType(bin) != 1) {
                throw new IOException("[initKey]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasKey() throws Exception {
        OutputStream output;
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream outputStream = output = this.session.output();
        synchronized (outputStream) {
            output.write(ConvertParam.convertInt(8));
            output.write(ConvertParam.convertInt(260));
            output.flush();
            byte[] bin = this.receive();
            if (MDbmClientConnection.resultType(bin) != 16) {
                throw new IOException("[hasKey]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
            }
            return MDbmClientConnection.booleanResult(bin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getKey() throws Exception {
        OutputStream output;
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream outputStream = output = this.session.output();
        synchronized (outputStream) {
            output.write(ConvertParam.convertInt(8));
            output.write(ConvertParam.convertInt(261));
            output.flush();
            byte[] bin = this.receive();
            if (MDbmClientConnection.resultType(bin) != 17) {
                throw new IOException("[getKey]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
            }
            return MDbmClientConnection.dataResult(bin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sequenceId(int no) throws Exception {
        OutputStream output;
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        OutputStream outputStream = output = this.session.output();
        synchronized (outputStream) {
            output.write(ConvertParam.convertInt(12));
            output.write(ConvertParam.convertInt(513));
            output.write(ConvertParam.convertInt(no));
            output.flush();
            byte[] bin = this.receive();
            if (MDbmClientConnection.resultType(bin) != 19) {
                throw new IOException("[sequenceId]\u7d50\u679c\u30d7\u30ed\u30c8\u30b3\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
            }
            return MDbmClientConnection.idResult(bin);
        }
    }

    public boolean isUse() {
        boolean ret = true;
        try {
            if (this.session == null || !this.session.isUse()) {
                ret = false;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    private static final int getType(byte[] bin) throws Exception {
        if (bin == null || bin.length < 8) {
            throw new IOException("\u4e0d\u6b63\u306a\u30d7\u30ed\u30c8\u30b3\u30eb\u3067\u3059");
        }
        return ConvertParam.convertInt(4, bin);
    }

    private static final int resultType(byte[] bin) throws Exception {
        int type = MDbmClientConnection.getType(bin);
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                throw new IOException(MDbmClientConnection.errorResult(bin));
            }
            case 16: {
                return 16;
            }
            case 17: {
                return 17;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 19;
            }
        }
        throw new IOException("\u4e0d\u6b63\u306a\u6761\u4ef6(" + type + ")\u304c\u8fd4\u3055\u308c\u307e\u3057\u305f");
    }

    private static final String errorResult(byte[] bin) throws Exception {
        int len = ConvertParam.convertInt(8, bin);
        int all = 12 + len;
        if (all != bin.length) {
            throw new IOException("[error]\u30d7\u30ed\u30c8\u30b3\u30eb\u5185\u5bb9\u306f\u4e0d\u6b63\u3067\u3059(" + all + "/" + bin.length + ")");
        }
        byte[] b = new byte[len];
        System.arraycopy(bin, 12, b, 0, len);
        return new String(b, "UTF8");
    }

    private static final boolean booleanResult(byte[] bin) throws Exception {
        int all = 9;
        if (all != bin.length) {
            throw new IOException("[boolean]\u30d7\u30ed\u30c8\u30b3\u30eb\u5185\u5bb9\u306f\u4e0d\u6b63\u3067\u3059(" + all + "/" + bin.length + ")");
        }
        return ConvertParam.convertBoolean(8, bin);
    }

    private static final int sizeResult(byte[] bin) throws Exception {
        int all = 12;
        if (all != bin.length) {
            throw new IOException("[int]\u30d7\u30ed\u30c8\u30b3\u30eb\u5185\u5bb9\u306f\u4e0d\u6b63\u3067\u3059(" + all + "/" + bin.length + ")");
        }
        return ConvertParam.convertInt(8, bin);
    }

    private static final long idResult(byte[] bin) throws Exception {
        int all = 16;
        if (all != bin.length) {
            throw new IOException("[long]\u30d7\u30ed\u30c8\u30b3\u30eb\u5185\u5bb9\u306f\u4e0d\u6b63\u3067\u3059(" + all + "/" + bin.length + ")");
        }
        return ConvertParam.convertLong(8, bin);
    }

    private static final byte[] dataResult(byte[] bin) throws Exception {
        int len = ConvertParam.convertInt(8, bin);
        int all = 12 + len;
        if (all != bin.length) {
            throw new IOException("[data]\u30d7\u30ed\u30c8\u30b3\u30eb\u5185\u5bb9\u306f\u4e0d\u6b63\u3067\u3059(" + all + "/" + bin.length + ")");
        }
        if (len <= 0) {
            return null;
        }
        byte[] ret = new byte[len];
        System.arraycopy(bin, 12, ret, 0, len);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] receive() throws Exception {
        if (!this.isUse()) {
            throw new IOException(NOT_ACCESS);
        }
        long time = System.currentTimeMillis() + 15000L;
        ResultClientQueue queue = this.session.getQueue();
        byte[] ret = null;
        while ((ret = queue.getQueue()) == null) {
            Object driverSync = this.session.getDriverSync();
            boolean rcvFlag = false;
            try {
                Object object = driverSync;
                synchronized (object) {
                    block24: {
                        if (this.isUse()) break block24;
                        this.destroy();
                        byte[] byArray = null;
                        return byArray;
                    }
                    boolean bl = rcvFlag = !this.session.isReceiveMethod() && this.session.isReceive();
                    if (rcvFlag) {
                        this.session.startReceive();
                    }
                }
                if (rcvFlag && (ret = this.session.receive()) != null) {
                    break;
                }
            }
            finally {
                if (rcvFlag) {
                    try {
                        this.session.exitReceive();
                    }
                    catch (Exception exception) {}
                }
            }
            if (!this.isUse()) {
                throw new IOException(NOT_ACCESS);
            }
            if (time <= System.currentTimeMillis()) {
                throw new IOException("\u53d7\u4fe1\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8");
            }
            Thread.sleep(5L);
        }
        return ret;
    }
}

